/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.group;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.atlasuser.api.group.AtlasGroup;
import de.resolution.atlasuser.api.group.AtlasGroupReference;
import de.resolution.atlasuser.impl.group.ImmutableAtlasGroupReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ImmutableAtlasGroup
implements AtlasGroup {
    private final Map<String, Set<String>> attributes;
    private final AtlasGroupReference atlasGroupReference;

    ImmutableAtlasGroup(@Nonnull AtlasGroupReference atlasGroupReference, @Nonnull Map<String, Set<String>> attributes) {
        this.atlasGroupReference = atlasGroupReference;
        this.attributes = new HashMap<String, Set<String>>();
        attributes.forEach((key, val) -> this.attributes.put((String)key, new HashSet(val)));
    }

    @JsonCreator
    ImmutableAtlasGroup(@JsonProperty(value="reference") ImmutableAtlasGroupReference atlasGroupReference, @JsonProperty(value="attributes") Map<String, Set<String>> attributes) {
        this((AtlasGroupReference)atlasGroupReference, attributes);
    }

    @Override
    @Nonnull
    public AtlasGroupReference getReference() {
        return this.atlasGroupReference;
    }

    @Override
    @Nonnull
    public Map<String, Set<String>> getAttributes() {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        this.attributes.forEach((key, value) -> ret.put((String)key, new HashSet(value)));
        return ret;
    }

    @Override
    @Nonnull
    public Set<String> getAttributeValues(@Nonnull String key) {
        Collection value = this.attributes.get(key);
        if (value == null || value.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(value);
    }

    @Override
    public boolean containsKey(@Nonnull String key) {
        return this.attributes.containsKey(key);
    }

    @Override
    @Nonnull
    public Set<String> getAttributeKeys() {
        return new HashSet<String>(this.attributes.keySet());
    }

    @Override
    @JsonIgnore
    public String getGroupName() {
        return this.get("ATTR_GROUPNAME").orElse(null);
    }
}

