/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.group;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.InvalidSearchFilterException;
import de.resolution.atlasuser.api.group.AtlasGroup;
import de.resolution.atlasuser.api.group.AtlasGroupAdapter;
import de.resolution.atlasuser.api.group.AtlasGroupReference;
import de.resolution.atlasuser.api.group.AtlasGroupResult;
import de.resolution.atlasuser.api.group.GroupSearchResult;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserKeys;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.api.user.SearchFilter;
import de.resolution.atlasuser.api.user.SortBy;
import de.resolution.atlasuser.api.user.UserSearchResult;
import de.resolution.atlasuser.impl.SimpleCancelHandle;
import de.resolution.atlasuser.impl.group.AtlasGroupBuilder;
import de.resolution.atlasuser.impl.group.AtlasGroupResultBuilder;
import de.resolution.commons.util.CollectionUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={AtlasGroupAdapter.class})
public class CrowdApiAtlasGroupAdapter
implements AtlasGroupAdapter {
    private static final Logger logger = LoggerFactory.getLogger(CrowdApiAtlasGroupAdapter.class);
    public static final List<String> SPECIAL_ATTRIBUTES = Collections.singletonList("ATTR_GROUPNAME");
    @Inject
    private AtlasUserAdapter atlasUserAdapter;
    @Inject
    private DirectoryManager directoryManager;

    @Override
    @Nonnull
    public AtlasGroupResult read(@Nonnull AtlasGroupReference reference) {
        AtlasGroupResultBuilder resultBuilder = AtlasGroupResult.builder(reference);
        try {
            GroupWithAttributes group = this.directoryManager.findGroupWithAttributesByName(reference.getDirectoryId(), reference.getGroupName());
            resultBuilder.resultingGroup(this.buildAtlasGroup(group));
        }
        catch (GroupNotFoundException e) {
            resultBuilder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            resultBuilder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e));
        }
        return resultBuilder.build();
    }

    @Override
    @Nonnull
    public AtlasGroupResult create(@Nonnull AtlasGroup atlasGroup) {
        AtlasGroupResultBuilder resultBuilder = AtlasGroupResult.builder(atlasGroup.getReference()).inputGroup(atlasGroup);
        AtlasGroupResult readResult = this.read(atlasGroup.getReference());
        if (readResult.isSuccess() && readResult.getResultingGroup().isPresent()) {
            return resultBuilder.errorType(AtlasGroupResult.ErrorType.NOT_UNIQUE).errorString(atlasGroup.getReference() + " already exists").build();
        }
        try {
            GroupTemplate groupTemplate = new GroupTemplate(atlasGroup.getGroupName(), atlasGroup.getReference().getDirectoryId());
            Group createdGroup = this.directoryManager.addGroup(atlasGroup.getReference().getDirectoryId(), groupTemplate);
            GroupWithAttributes groupWithAttributes = this.directoryManager.findGroupWithAttributesByName(createdGroup.getDirectoryId(), createdGroup.getName());
            resultBuilder = this.updateCrowdAttributes(groupWithAttributes, atlasGroup, resultBuilder);
            groupWithAttributes = this.directoryManager.findGroupWithAttributesByName(createdGroup.getDirectoryId(), createdGroup.getName());
            resultBuilder.resultingGroup(this.buildAtlasGroup(groupWithAttributes));
            resultBuilder.operation(AtlasGroupResult.Operation.ADDED);
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | InvalidGroupException | OperationFailedException | DirectoryPermissionException e) {
            resultBuilder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e));
        }
        return resultBuilder.build();
    }

    @Override
    @Nonnull
    public AtlasGroupResult update(@Nonnull AtlasGroup atlasGroup) {
        AtlasGroupResultBuilder resultBuilder = AtlasGroupResult.builder(atlasGroup.getReference()).inputGroup(atlasGroup);
        try {
            this.findGroup(atlasGroup.getReference());
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            return resultBuilder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        catch (GroupNotFoundException e) {
            return resultBuilder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND).errorString(atlasGroup.getReference() + " does not exist").build();
        }
        try {
            GroupWithAttributes initialGroup = this.findGroup(atlasGroup.getReference());
            resultBuilder.initialGroup(this.buildAtlasGroup(initialGroup));
            resultBuilder = this.updateCrowdAttributes(initialGroup, atlasGroup, resultBuilder);
            GroupWithAttributes reloadedGroup = this.findGroup(atlasGroup.getReference());
            resultBuilder.resultingGroup(this.buildAtlasGroup(reloadedGroup));
            resultBuilder.operation(AtlasGroupResult.Operation.UPDATED);
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException e) {
            resultBuilder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e));
        }
        return resultBuilder.build();
    }

    @Nonnull
    private GroupWithAttributes findGroup(AtlasGroupReference groupReference) throws DirectoryNotFoundException, OperationFailedException, GroupNotFoundException {
        return this.directoryManager.findGroupWithAttributesByName(groupReference.getDirectoryId(), groupReference.getGroupName());
    }

    @Override
    @Nonnull
    public AtlasGroupResult delete(@Nonnull AtlasGroupReference reference) {
        AtlasGroupResultBuilder resultBuilder = AtlasGroupResult.builder(reference);
        try {
            this.findGroup(reference);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            return resultBuilder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        catch (GroupNotFoundException e) {
            return resultBuilder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND).errorString(reference + " does not exist").build();
        }
        try {
            this.directoryManager.removeGroup(reference.getDirectoryId(), reference.getGroupName());
            resultBuilder.operation(AtlasGroupResult.Operation.DELETED);
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException | ReadOnlyGroupException | DirectoryPermissionException e) {
            resultBuilder.exceptionInfo(ExceptionInfo.from(e));
        }
        return resultBuilder.build();
    }

    @Nonnull
    private AtlasGroup buildAtlasGroup(@Nonnull GroupWithAttributes group) {
        AtlasGroupBuilder builder = AtlasGroup.builder().findBy(AtlasGroupReference.create(group.getName(), group.getDirectoryId()));
        builder.groupName(group.getName());
        for (String key : group.getKeys()) {
            Set values2 = group.getValues(key);
            if (values2 == null || values2.isEmpty()) continue;
            builder.with(key, values2);
        }
        return builder.build();
    }

    @Nonnull
    private AtlasGroupResultBuilder updateCrowdAttributes(@Nonnull GroupWithAttributes group, @Nonnull AtlasGroup atlasGroup, @Nonnull AtlasGroupResultBuilder resultBuilder) {
        try {
            Set attributeNames = atlasGroup.getAttributeKeys().stream().filter(key -> !SPECIAL_ATTRIBUTES.contains(key)).filter(key -> AtlasUserKeys.APPLICATION_PREFIXES.stream().noneMatch(key::startsWith)).collect(Collectors.toSet());
            Set crowdUserKeys = group.getKeys();
            Set keysToRemove = crowdUserKeys.stream().filter(key -> attributeNames.contains(key) && atlasGroup.getAttributeValues((String)key).isEmpty()).collect(Collectors.toSet());
            Set keysToAdd = attributeNames.stream().filter(key -> !atlasGroup.getAttributeValues((String)key).isEmpty() && !crowdUserKeys.contains(key)).collect(Collectors.toSet());
            HashMap<String, Set<String>> attributesToAdd = new HashMap<String, Set<String>>();
            for (String key2 : keysToAdd) {
                attributesToAdd.put(key2, atlasGroup.getAttributeValues(key2));
            }
            Set keysToUpdate = attributeNames.stream().filter(key -> !atlasGroup.getAttributeValues((String)key).isEmpty() && crowdUserKeys.contains(key) && !CollectionUtil.containsSame(atlasGroup.getAttributeValues((String)key), group.getValues(key))).collect(Collectors.toSet());
            boolean updated = false;
            for (String key3 : keysToRemove) {
                this.directoryManager.removeGroupAttributes(group.getDirectoryId(), group.getName(), key3);
                updated = true;
            }
            if (!attributesToAdd.isEmpty()) {
                this.directoryManager.storeGroupAttributes(group.getDirectoryId(), group.getName(), attributesToAdd);
                updated = true;
            }
            HashMap<String, Set<String>> attributesToUpdate = new HashMap<String, Set<String>>();
            for (String key4 : keysToUpdate) {
                attributesToUpdate.put(key4, atlasGroup.getAttributeValues(key4));
            }
            if (!attributesToUpdate.isEmpty()) {
                this.directoryManager.storeGroupAttributes(group.getDirectoryId(), group.getName(), attributesToUpdate);
                updated = true;
            }
            if (updated) {
                resultBuilder.operation(resultBuilder.getOperation() == AtlasGroupResult.Operation.ADDED ? AtlasGroupResult.Operation.ADDED : AtlasGroupResult.Operation.UPDATED);
            }
            return resultBuilder;
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException | DirectoryPermissionException e) {
            return resultBuilder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).errorString("Updating attributes for group " + group.getName() + " in directory " + group.getDirectoryId() + " failed");
        }
    }

    @Override
    @Nonnull
    public GroupSearchResult search(int startIndex, int count, long directoryId) throws AtlasUserOperationFailedException {
        try {
            if (count <= 0) {
                count = 1000;
            }
            EntityQuery groupQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).startingAt(startIndex).returningAtMost(count);
            List groupNames = this.directoryManager.searchGroups(directoryId, groupQuery);
            List<AtlasGroup> atlasGroups = groupNames.stream().map(groupname -> AtlasGroup.builder().findBy(AtlasGroupReference.create(groupname, directoryId)).groupName((String)groupname).build()).collect(Collectors.toList());
            return new GroupSearchResult(startIndex, count, atlasGroups);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new AtlasUserOperationFailedException(e);
        }
    }

    @Override
    @Nonnull
    public UserSearchResult getDirectMemberships(@Nonnull AtlasGroupReference groupReference) throws AtlasUserOperationFailedException, de.resolution.atlasuser.api.exception.DirectoryNotFoundException, InvalidSearchFilterException {
        SearchFilter searchFilter = SearchFilter.builder().inGroups(groupReference.getGroupName()).directoryId(groupReference.getDirectoryId()).build();
        return this.atlasUserAdapter.search(searchFilter, SortBy.name(), new SimpleCancelHandle());
    }

    @Override
    public boolean isUserInGroup(@Nonnull AtlasGroupReference groupReference, @Nonnull AtlasUserReference userReference) {
        String username;
        if ("ATTR_NAME".equals(userReference.getFindByAttributeName())) {
            username = userReference.getFindByAttributeValue();
        } else {
            AtlasUserResult atlasUserResult = this.atlasUserAdapter.readFirstUniqueUser(userReference);
            Optional<AtlasUser> optionalResultingUser = atlasUserResult.getResultingUser();
            if (atlasUserResult.isSuccess() && optionalResultingUser.isPresent()) {
                AtlasUser atlasUser = optionalResultingUser.get();
                username = atlasUser.getName();
            } else {
                logger.debug("Checking group relation failed, user {} not found", (Object)userReference);
                return false;
            }
        }
        try {
            return this.directoryManager.isUserDirectGroupMember(groupReference.getDirectoryId(), username, groupReference.getGroupName());
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            logger.debug("Checking group relation failed", e);
            return false;
        }
    }

    @Override
    @Nonnull
    public AtlasGroupResult addUserToGroup(@Nonnull AtlasGroupReference groupReference, @Nonnull AtlasUserReference userReference) {
        AtlasGroupResultBuilder builder = new AtlasGroupResultBuilder(groupReference);
        AtlasUserResult atlasUserResult = this.atlasUserAdapter.readFirstUniqueUser(userReference);
        Optional<AtlasUser> optionalResultingUser = atlasUserResult.getResultingUser();
        if (!atlasUserResult.isSuccess() || !optionalResultingUser.isPresent()) {
            return builder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND).addMessage("User <" + userReference.getFindByAttributeName() + ":" + userReference.getFindByAttributeValue() + "> does not exist").build();
        }
        String username = optionalResultingUser.get().getName();
        try {
            this.findGroup(groupReference);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        catch (GroupNotFoundException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND).addMessage("Group does not exist").build();
        }
        try {
            this.directoryManager.addUserToGroup(groupReference.getDirectoryId(), username, groupReference.getGroupName());
        }
        catch (MembershipAlreadyExistsException e) {
            return builder.operation(AtlasGroupResult.Operation.NOT_MODIFIED).addMessage(e.getMessage()).build();
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException | ReadOnlyGroupException | UserNotFoundException | DirectoryPermissionException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        AtlasGroupResult reloadedGroup = this.read(groupReference);
        Optional<AtlasGroup> reloadedOptionalResultingGroup = reloadedGroup.getResultingGroup();
        if (!reloadedGroup.isSuccess() || !reloadedOptionalResultingGroup.isPresent()) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).addMessage("Could not reload group after assigning user").build();
        }
        builder.operation(AtlasGroupResult.Operation.MEMBER_ADDED);
        builder.resultingGroup(reloadedOptionalResultingGroup.get());
        return builder.build();
    }

    @Override
    @Nonnull
    public AtlasGroupResult removeUserFromGroup(@Nonnull AtlasGroupReference groupReference, @Nonnull AtlasUserReference userReference) {
        AtlasGroupResultBuilder builder = new AtlasGroupResultBuilder(groupReference);
        AtlasUserResult atlasUserResult = this.atlasUserAdapter.readFirstUniqueUser(userReference);
        Optional<AtlasUser> optionalResultingUser = atlasUserResult.getResultingUser();
        if (!atlasUserResult.isSuccess() || !optionalResultingUser.isPresent()) {
            return builder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND).addMessage("User does not exist").build();
        }
        String username = optionalResultingUser.get().getName();
        try {
            this.findGroup(groupReference);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        catch (GroupNotFoundException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND).addMessage("Group does not exist").build();
        }
        try {
            this.directoryManager.removeUserFromGroup(groupReference.getDirectoryId(), username, groupReference.getGroupName());
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | MembershipNotFoundException | OperationFailedException | ReadOnlyGroupException | UserNotFoundException | DirectoryPermissionException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        AtlasGroupResult reloadedGroup = this.read(groupReference);
        Optional<AtlasGroup> reloadedOptionalResultingGroup = reloadedGroup.getResultingGroup();
        if (!reloadedGroup.isSuccess() || !reloadedOptionalResultingGroup.isPresent()) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).addMessage("Could not reload group after assigning user").build();
        }
        builder.operation(AtlasGroupResult.Operation.MEMBER_REMOVED);
        builder.resultingGroup(reloadedOptionalResultingGroup.get());
        return builder.build();
    }
}

