/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl;

import de.resolution.atlasuser.api.AtlasUserStatusObject;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class SimpleAtlasUserStatusObject
implements AtlasUserStatusObject {
    private volatile boolean cancelled = false;
    private String message = null;
    private int added = 0;
    private int deleted = 0;
    private int updated = 0;
    private int notModified = 0;
    private int failed = 0;
    private int filtered = 0;
    private final List<AtlasUserResult> resultList = new ArrayList<AtlasUserResult>();

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return this.message;
    }

    @Override
    public void setStatusMessage(@Nullable String message) {
        this.message = message;
    }

    @Override
    public int getAddedCount() {
        return this.added;
    }

    @Override
    public int getUpdatedCount() {
        return this.updated;
    }

    @Override
    public int getDeletedCount() {
        return this.deleted;
    }

    @Override
    public int getNotModifiedCount() {
        return this.notModified;
    }

    @Override
    public int getFailedCount() {
        return this.failed;
    }

    @Override
    public void addFiltered() {
        ++this.filtered;
    }

    @Override
    public int getFilteredCount() {
        return this.filtered;
    }

    @Override
    public void add(AtlasUserResult result) {
        this.resultList.add(result);
        if (result.isSuccess()) {
            switch (result.getOperation()) {
                case ADDED: {
                    ++this.added;
                    break;
                }
                case NOT_MODIFIED: {
                    ++this.notModified;
                    break;
                }
                case DELETED: {
                    ++this.deleted;
                    break;
                }
                case UPDATED: {
                    ++this.updated;
                    break;
                }
                case NONE: {
                    break;
                }
            }
        } else {
            ++this.failed;
        }
    }

    @Override
    public int getResultCount() {
        return this.resultList.size();
    }

    public List<AtlasUserResult> getResultList() {
        return this.resultList;
    }
}

