/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import de.resolution.atlasuser.api.LicenseCountProvider;
import de.resolution.atlasuser.api.exception.AtlasUserRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
@ExportAsService(value={LicenseCountProvider.class})
public class ConfluenceLicenseCountProvider
implements LicenseCountProvider {
    private final UserAccessor userAccessor;
    private final LicenseHandler licenseHandler;

    @Autowired
    public ConfluenceLicenseCountProvider(@ConfluenceImport UserAccessor userAccessor, @ConfluenceImport LicenseHandler licenseHandler) {
        this.userAccessor = userAccessor;
        this.licenseHandler = licenseHandler;
    }

    @Override
    public int getAvailableConfluenceUserLicenses() {
        SingleProductLicenseDetailsView licenseDetailsView = this.licenseHandler.getProductLicenseDetails("conf");
        if (licenseDetailsView == null) {
            throw new AtlasUserRuntimeException("getProductLicenseDetails(\"conf\") returned null");
        }
        if (licenseDetailsView.isUnlimitedNumberOfUsers()) {
            return Integer.MAX_VALUE;
        }
        int maxUsers = licenseDetailsView.getNumberOfUsers();
        int userCount = this.userAccessor.countLicenseConsumingUsers();
        if (userCount >= maxUsers) {
            return 0;
        }
        return maxUsers - userCount;
    }
}

