/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasauth.impl;

import de.resolution.commons.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectChecker {
    private static final List<String> illegalStrings = Arrays.asList(";", "%3b", "..", "/\\", "%2e%2e", "%c0ae%c0ae", "%252e%252e");
    private static final String ILLEGAL_URL_END = ".js";
    private static final Logger logger = LoggerFactory.getLogger(RedirectChecker.class);

    private RedirectChecker() {
    }

    @Nonnull
    public static String getRedirectURL(boolean isSkipBaseUrlCheck, @Nonnull String baseUrlForRequest, @Nonnull String relativeBaseUrl, @Nullable String redirectTarget, @Nonnull String defaultRelativeRedirectUrl) {
        if (redirectTarget == null || redirectTarget.trim().isEmpty()) {
            logger.debug("RelayState is null or empty, setting it to {}", (Object)defaultRelativeRedirectUrl);
            return defaultRelativeRedirectUrl;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RelayState is {}", (Object)StringUtil.sanitize(redirectTarget));
        }
        if (redirectTarget.startsWith("/") && !redirectTarget.startsWith("//")) {
            redirectTarget = relativeBaseUrl + redirectTarget;
        }
        if (isSkipBaseUrlCheck) {
            return redirectTarget;
        }
        if (RedirectChecker.containsIllegalCharsOrUrlEndingInRedirectTarget(redirectTarget)) {
            return defaultRelativeRedirectUrl;
        }
        HttpUrl baseUrl = HttpUrl.parse(baseUrlForRequest);
        if (baseUrl == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Error checking redirect URL (baseUrl \"{}\" could not be resolved), redirecting to default redirect URL {}", (Object)StringUtil.sanitize(baseUrlForRequest + redirectTarget), (Object)defaultRelativeRedirectUrl);
            }
            return defaultRelativeRedirectUrl;
        }
        HttpUrl resolvedDestination = baseUrl.resolve(redirectTarget);
        if (resolvedDestination == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Could not resolve url to redirect to for {}{}", (Object)StringUtil.sanitize(baseUrl.toString()), (Object)StringUtil.sanitize(redirectTarget));
            }
            return defaultRelativeRedirectUrl;
        }
        if (!baseUrl.host().equals(resolvedDestination.host())) {
            logger.warn("Destination to redirect to does not belong to base url. Destination is {}", (Object)resolvedDestination);
            return defaultRelativeRedirectUrl;
        }
        if (RedirectChecker.containsIllegalCharsOrUrlEndingInRedirectTarget(resolvedDestination.encodedPath())) {
            return defaultRelativeRedirectUrl;
        }
        if (!resolvedDestination.username().isEmpty() || !resolvedDestination.encodedUsername().isEmpty()) {
            if (logger.isWarnEnabled()) {
                logger.warn("Redirect URL {} contains userinfo and is considered as invalid!", (Object)StringUtil.sanitize(redirectTarget));
            }
            return defaultRelativeRedirectUrl;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Redirect URL {} is valid", (Object)StringUtil.sanitize(redirectTarget));
        }
        return redirectTarget;
    }

    @Nonnull
    public static String adjustOsDestinationIfNecessary(@Nonnull String osDestination) {
        if (!(osDestination.startsWith("/") || osDestination.startsWith("http://") || osDestination.startsWith("https://"))) {
            osDestination = "/" + osDestination;
        }
        return osDestination;
    }

    private static boolean containsIllegalCharsOrUrlEndingInRedirectTarget(String toTest) {
        toTest = toTest.toLowerCase(Locale.US);
        if (illegalStrings.stream().anyMatch(toTest::contains) || toTest.startsWith("/s/") && toTest.endsWith(ILLEGAL_URL_END) || toTest.startsWith("%2f%2f")) {
            if (logger.isErrorEnabled()) {
                logger.error("The resolved url contains an illegal string: {}", (Object)StringUtil.sanitize(toTest));
            }
            return true;
        }
        return false;
    }
}

