/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasauth.impl;

import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import de.resolution.atlasauth.impl.AuthenticatorHook;
import de.resolution.atlasauth.impl.AuthenticatorHookException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticatorHook
implements AuthenticatorHook {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAuthenticatorHook.class);

    protected abstract DefaultAuthenticator getAuthenticator();

    @Override
    public boolean authoriseUserAndEstablishSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Principal principal, boolean setRememberMe, boolean sdCustomerLogin) {
        boolean authenticated = this.doAuthoriseUserAndEstablishSession(httpServletRequest, httpServletResponse, principal, sdCustomerLogin);
        return authenticated;
    }

    public abstract boolean doAuthoriseUserAndEstablishSession(HttpServletRequest var1, HttpServletResponse var2, Principal var3, boolean var4);

    @Override
    public boolean logout(HttpServletRequest req, HttpServletResponse resp) throws AuthenticatorHookException {
        logger.debug("Calling Authenticator.logout()");
        HttpSession currentSession = req.getSession(false);
        if (currentSession != null) {
            currentSession.invalidate();
        }
        try {
            boolean logoutSuccessful = this.getAuthenticator().logout(req, resp);
            logger.debug("Logout was {}", (Object)logoutSuccessful);
            return logoutSuccessful;
        }
        catch (AuthenticatorException e) {
            logger.error("Something went wrong during logout", (Throwable)e);
            return false;
        }
    }
}

