/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.albauth.auditlogservice;

import com.atlassian.confluence.api.model.audit.AffectedObject;
import com.atlassian.confluence.api.model.audit.AuditRecord;
import com.atlassian.confluence.api.model.people.KnownUser;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.service.audit.AuditService;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.user.UserProfile;
import de.resolution.albauth.auditlogservice.AuditLogService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
public class ConfluenceAuditLogService
implements AuditLogService {
    private final AuditService auditService;

    @Autowired
    public ConfluenceAuditLogService(@ConfluenceImport AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    public void postMessage(@Nonnull String appName, @Nonnull String msg, @Nonnull UserProfile author) {
        this.auditService.storeRecord(this.createRecord(appName, msg, author));
    }

    @Override
    public void postMessage(@Nonnull String appName, @Nonnull String msg) {
        this.auditService.storeRecord(this.createRecord(appName, msg));
    }

    private AuditRecord createRecord(@Nonnull String appName, @Nonnull String summary, @Nullable UserProfile author) {
        AuditRecord.Builder builder = new AuditRecord.Builder();
        builder.summary(summary);
        builder.category("Apps");
        AffectedObject af = new AffectedObject.Builder().name(appName).objectType("App").build();
        builder.affectedObject(af);
        if (author != null) {
            KnownUser kAuthor = new KnownUser.Builder().displayName(author.getFullName()).userKey(author.getUserKey()).username(author.getUsername()).build();
            builder.author((User)kAuthor);
        }
        return builder.build();
    }

    private AuditRecord createRecord(@Nonnull String appName, @Nonnull String summary) {
        return this.createRecord(appName, summary, null);
    }
}

