/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.albauth;

import java.io.IOException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlbJwtUtils {
    private static final Logger logger = LoggerFactory.getLogger(AlbJwtUtils.class);

    private AlbJwtUtils() {
    }

    @Nullable
    public static PublicKey createPublicKeyFromString(@Nonnull String key) {
        String preparedKey = AlbJwtUtils.preparePublicKeyString(key);
        try {
            byte[] byteKey = Base64.getDecoder().decode(preparedKey.getBytes());
            X509EncodedKeySpec x509publicKey = new X509EncodedKeySpec(byteKey);
            KeyFactory kf = KeyFactory.getInstance("EC");
            return kf.generatePublic(x509publicKey);
        }
        catch (Exception e) {
            logger.error("While creating the PublicKey object, the following error occurred: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Nonnull
    public static String preparePublicKeyString(@Nonnull String toPrepare) {
        return toPrepare.replace("-----BEGIN PUBLIC KEY-----", "").replaceAll(System.lineSeparator(), "").replace("-----END PUBLIC KEY-----", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getPublicKeyString(@Nonnull String region, @Nonnull String kid) {
        String url = "https://public-keys.auth.elb.REGION.amazonaws.com/KID";
        String urlToUse = "https://public-keys.auth.elb.REGION.amazonaws.com/KID".replace("REGION", region).replace("KID", kid);
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(urlToUse).build();
        try (Response response = client.newCall(request).execute();){
            if (response.body() != null) {
                String string = response.body().string();
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            logger.error("Retrieving public key failed because of {}", (Object)e.getMessage());
            return null;
        }
    }
}

