/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.utils;

import com.unboundid.scim2.common.utils.DebugType;
import com.unboundid.scim2.common.utils.StaticUtils;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Debug
implements Serializable {
    public static final String PROPERTY_DEBUG_ENABLED = "com.unboundid.scim2.sdk.debug.enabled";
    public static final String PROPERTY_INCLUDE_STACK_TRACE = "com.unboundid.scim2.sdk.debug.includeStackTrace";
    public static final String PROPERTY_DEBUG_LEVEL = "com.unboundid.scim2.sdk.debug.level";
    public static final String PROPERTY_DEBUG_TYPE = "com.unboundid.scim2.sdk.debug.type";
    public static final String LOGGER_NAME = "com.unboundid.scim2.sdk";
    private static final Logger logger = Logger.getLogger("com.unboundid.scim2.sdk");
    private static final long serialVersionUID = 1481879450652966238L;
    private static boolean debugEnabled;
    private static boolean includeStackTrace;
    private static EnumSet<DebugType> debugTypes;

    private Debug() {
    }

    public static void initialize() {
        includeStackTrace = false;
        debugEnabled = false;
        debugTypes = EnumSet.allOf(DebugType.class);
        logger.setLevel(Level.ALL);
    }

    public static void initialize(Properties properties) {
        String levelProp;
        String typesProp;
        String stackProp;
        Debug.initialize();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        String enabledProp = properties.getProperty(PROPERTY_DEBUG_ENABLED);
        if (enabledProp != null && enabledProp.length() > 0) {
            if (enabledProp.equalsIgnoreCase("true")) {
                debugEnabled = true;
            } else if (enabledProp.equalsIgnoreCase("false")) {
                debugEnabled = false;
            } else {
                throw new IllegalArgumentException("Invalid value '" + enabledProp + "' for property " + PROPERTY_DEBUG_ENABLED + ".  The value must be either 'true' or 'false'.");
            }
        }
        if ((stackProp = properties.getProperty(PROPERTY_INCLUDE_STACK_TRACE)) != null && stackProp.length() > 0) {
            if (stackProp.equalsIgnoreCase("true")) {
                includeStackTrace = true;
            } else if (stackProp.equalsIgnoreCase("false")) {
                includeStackTrace = false;
            } else {
                throw new IllegalArgumentException("Invalid value '" + stackProp + "' for property " + PROPERTY_INCLUDE_STACK_TRACE + ".  The value must be either 'true' or 'false'.");
            }
        }
        if ((typesProp = properties.getProperty(PROPERTY_DEBUG_TYPE)) != null && typesProp.length() > 0) {
            debugTypes = EnumSet.noneOf(DebugType.class);
            StringTokenizer t = new StringTokenizer(typesProp, ", ");
            while (t.hasMoreTokens()) {
                String debugTypeName = t.nextToken();
                DebugType debugType = DebugType.forName(debugTypeName);
                if (debugType == null) {
                    throw new IllegalArgumentException("Invalid value '" + debugTypeName + "' for property " + PROPERTY_DEBUG_TYPE + ".  Allowed values include:  " + DebugType.getTypeNameList() + '.');
                }
                debugTypes.add(debugType);
            }
        }
        if ((levelProp = properties.getProperty(PROPERTY_DEBUG_LEVEL)) != null && levelProp.length() > 0) {
            logger.setLevel(Level.parse(levelProp));
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public static boolean debugEnabled() {
        return debugEnabled;
    }

    public static boolean debugEnabled(DebugType debugType) {
        return debugEnabled && debugTypes.contains((Object)debugType);
    }

    public static void setEnabled(boolean enabled) {
        debugTypes = EnumSet.allOf(DebugType.class);
        debugEnabled = enabled;
    }

    public static void setEnabled(boolean enabled, Set<DebugType> types) {
        debugTypes = types == null || types.isEmpty() ? EnumSet.allOf(DebugType.class) : EnumSet.copyOf(types);
        debugEnabled = enabled;
    }

    public static boolean includeStackTrace() {
        return includeStackTrace;
    }

    public static void setIncludeStackTrace(boolean includeStackTrace) {
        Debug.includeStackTrace = includeStackTrace;
    }

    public static EnumSet<DebugType> getDebugTypes() {
        return debugTypes;
    }

    public static void debugException(Throwable t) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.EXCEPTION)) {
            Debug.debugException(Level.WARNING, t);
        }
    }

    public static void debugException(Level l, Throwable t) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.EXCEPTION)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("caughtException=\"");
            StaticUtils.getStackTrace(t, buffer);
            buffer.append('\"');
            logger.log(l, buffer.toString(), t);
        }
    }

    public static void debugCodingError(Throwable t) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CODING_ERROR)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, Level.SEVERE);
            buffer.append("codingError=\"");
            StaticUtils.getStackTrace(t, buffer);
            buffer.append('\"');
            logger.log(Level.SEVERE, buffer.toString());
        }
    }

    public static void debug(Level l, DebugType t, String m) {
        if (debugEnabled && debugTypes.contains((Object)t)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("message=\"");
            buffer.append(m);
            buffer.append('\"');
            logger.log(l, buffer.toString());
        }
    }

    public static void debug(Level l, DebugType t, String m, Throwable e) {
        if (debugEnabled && debugTypes.contains((Object)t)) {
            StringBuilder buffer = new StringBuilder();
            Debug.addCommonHeader(buffer, l);
            buffer.append("message=\"");
            buffer.append(m);
            buffer.append('\"');
            buffer.append(" exception=\"");
            StaticUtils.getStackTrace(e, buffer);
            buffer.append('\"');
            logger.log(l, buffer.toString(), e);
        }
    }

    private static void addCommonHeader(StringBuilder buffer, Level level) {
        buffer.append("level=\"");
        buffer.append(level.getName());
        buffer.append("\" threadID=");
        buffer.append(Thread.currentThread().getId());
        buffer.append(" threadName=\"");
        buffer.append(Thread.currentThread().getName());
        if (includeStackTrace) {
            buffer.append("\" calledFrom=\"");
            boolean appended = false;
            boolean foundDebug = false;
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                String className = e.getClassName();
                if (className.equals(Debug.class.getName())) {
                    foundDebug = true;
                    continue;
                }
                if (!foundDebug) continue;
                if (appended) {
                    buffer.append(" / ");
                }
                appended = true;
                buffer.append(e.getMethodName());
                buffer.append('(');
                buffer.append(e.getFileName());
                int lineNumber = e.getLineNumber();
                if (lineNumber > 0) {
                    buffer.append(':');
                    buffer.append(lineNumber);
                } else if (e.isNativeMethod()) {
                    buffer.append(":native");
                }
                buffer.append(')');
            }
        }
        buffer.append("\" revision=");
        buffer.append("75c680b6848cf4cad88563e75f1d91a24cb4f241");
        buffer.append(' ');
    }

    static {
        Debug.initialize(System.getProperties());
    }
}

