/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics.messages;

import com.segment.analytics.messages.ImmutableMap;
import com.segment.analytics.messages.Message;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public abstract class MessageBuilder<T extends Message, V extends MessageBuilder> {
    private final Message.Type type;
    private String messageId;
    private Date timestamp;
    private Map<String, ?> context;
    private String anonymousId;
    private String userId;
    private Map<String, Object> integrations;

    MessageBuilder(Message.Type type) {
        this.type = type;
    }

    MessageBuilder(Message message) {
        this.type = message.type();
        this.context = message.context();
        this.anonymousId = message.anonymousId();
        this.userId = message.userId();
    }

    static boolean isNullOrEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public V messageId(UUID messageId) {
        if (messageId == null) {
            throw new NullPointerException("Null messageId");
        }
        this.messageId = messageId.toString();
        return this.self();
    }

    public V messageId(String messageId) {
        if (MessageBuilder.isNullOrEmpty(messageId)) {
            throw new IllegalArgumentException("messageId cannot be null or empty.");
        }
        this.messageId = messageId;
        return this.self();
    }

    public V timestamp(Date timestamp) {
        if (timestamp == null) {
            throw new NullPointerException("Null timestamp");
        }
        this.timestamp = timestamp;
        return this.self();
    }

    public V context(Map<String, ?> context) {
        if (context == null) {
            throw new NullPointerException("Null context");
        }
        this.context = ImmutableMap.copyOf(context);
        return this.self();
    }

    public V anonymousId(UUID anonymousId) {
        if (anonymousId == null) {
            throw new NullPointerException("Null anonymousId");
        }
        this.anonymousId = anonymousId.toString();
        return this.self();
    }

    public V anonymousId(String anonymousId) {
        this.anonymousId = anonymousId;
        return this.self();
    }

    public V userId(String userId) {
        this.userId = userId;
        return this.self();
    }

    public V enableIntegration(String key, boolean enable) {
        if (MessageBuilder.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("Key cannot be null or empty.");
        }
        if (this.integrations == null) {
            this.integrations = new LinkedHashMap<String, Object>();
        }
        this.integrations.put(key, enable);
        return this.self();
    }

    public V integrationOptions(String key, Map<String, ?> options) {
        if (MessageBuilder.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("Key cannot be null or empty.");
        }
        if (this.integrations == null) {
            this.integrations = new LinkedHashMap<String, Object>();
        }
        this.integrations.put(key, ImmutableMap.copyOf(options));
        return this.self();
    }

    protected abstract T realBuild(Message.Type var1, String var2, Date var3, Map<String, ?> var4, String var5, String var6, Map<String, Object> var7);

    abstract V self();

    public T build() {
        String messageId;
        if (MessageBuilder.isNullOrEmpty(this.anonymousId) && MessageBuilder.isNullOrEmpty(this.userId)) {
            throw new IllegalArgumentException("Either anonymousId or userId must be provided.");
        }
        Date timestamp = this.timestamp;
        if (timestamp == null) {
            timestamp = new Date();
        }
        if ((messageId = this.messageId) == null) {
            messageId = UUID.randomUUID().toString();
        }
        Map<Object, Object> integrations = this.integrations == null ? Collections.emptyMap() : ImmutableMap.copyOf(this.integrations);
        return this.realBuild(this.type, messageId, timestamp, this.context, this.anonymousId, this.userId, integrations);
    }

    public Message.Type type() {
        return this.type;
    }
}

