/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import org.apache.poi.ss.formula.functions.FreeRefFunction;

public final class BesselJ
extends Fixed2ArgFunction
implements FreeRefFunction {
    public static final FreeRefFunction instance = new BesselJ();

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg1, ValueEval arg2) {
        try {
            Double xval = BesselJ.evaluateValue(arg1, srcRowIndex, srcColumnIndex);
            if (xval == null) {
                return ErrorEval.VALUE_INVALID;
            }
            Double orderDouble = BesselJ.evaluateValue(arg2, srcRowIndex, srcColumnIndex);
            if (orderDouble == null) {
                return ErrorEval.VALUE_INVALID;
            }
            int order = orderDouble.intValue();
            if (order < 0) {
                return ErrorEval.NUM_ERROR;
            }
            double result = org.apache.commons.math3.special.BesselJ.value(order, xval);
            return new NumberEval(result);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    @Override
    public ValueEval evaluate(ValueEval[] args2, OperationEvaluationContext ec) {
        if (args2.length == 2) {
            return this.evaluate(ec.getRowIndex(), ec.getColumnIndex(), args2[0], args2[1]);
        }
        return ErrorEval.VALUE_INVALID;
    }

    private static Double evaluateValue(ValueEval arg, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
        ValueEval veText = OperandResolver.getSingleValue(arg, srcRowIndex, srcColumnIndex);
        String strText1 = OperandResolver.coerceValueToString(veText);
        return OperandResolver.parseDouble(strText1);
    }
}

