/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.AttributeNotSearchableException;
import de.resolution.atlasuser.api.exception.AttributeNotUniqueException;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.impl.AttributeIndex;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.retransform.api.TransformationFailedException;
import de.resolution.usersync.api.LinchpinEventSender;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.SyncUserResult;
import de.resolution.usersync.api.exception.UserFindFailedException;
import de.resolution.usersync.impl.SyncStatusFacadeImpl;
import de.resolution.usersync.spi.Connector;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncFunctionImpl
implements SyncFunction {
    private static final Logger logger = LoggerFactory.getLogger(SyncFunctionImpl.class);
    private final Connector<?> connector;
    private final AtlasUserAdapter atlasUserAdapter;
    private final SyncStatus syncStatus;
    private final SyncStatusFacade syncStatusFacade;
    @Nullable
    private AttributeIndex attributeIndex = null;
    private final long timestamp;
    private final LinchpinEventSender linchpinEventSender;

    public SyncFunctionImpl(Connector<?> connector, AtlasUserAdapter atlasUserAdapter, SyncStatus syncStatus, LinchpinEventSender linchpinEventSender) {
        this.connector = connector;
        this.atlasUserAdapter = atlasUserAdapter;
        this.syncStatus = syncStatus;
        this.syncStatusFacade = new SyncStatusFacadeImpl(syncStatus);
        this.timestamp = System.currentTimeMillis();
        this.linchpinEventSender = linchpinEventSender;
    }

    @Override
    public void accept(@Nonnull MapStructuredData userAttributes) {
        this.syncStatusFacade.checkCancel();
        try {
            SyncUserResult syncUserResult = this.connector.syncUser(userAttributes, null, this.attributeIndex, null, this.timestamp);
            this.syncStatusFacade.add(syncUserResult);
            if (!syncUserResult.isSuccess() && syncUserResult.getMessage() != null) {
                this.syncStatusFacade.add(syncUserResult.getMessage(), SyncStatusFacade.LogLevel.WARN, logger);
            }
        }
        catch (TransformationFailedException e) {
            this.syncStatusFacade.fail("Transformation failed: " + e.getMessage(), e, logger);
        }
        catch (UserFindFailedException e) {
            this.syncStatusFacade.fail("Loading user failed: " + e.getMessage(), e, logger);
        }
    }

    @Override
    @Nonnull
    public AtlasUserAdapter getAtlasUserAdapter() {
        return this.atlasUserAdapter;
    }

    @Override
    public void buildIndex() throws AtlasUserOperationFailedException, AttributeNotSearchableException, AttributeNotUniqueException {
        Instant startTime = Instant.now();
        Object configuration = this.connector.getConfiguration();
        this.attributeIndex = this.atlasUserAdapter.buildIndex(configuration.getDirectoryId(), configuration.getFindByAttributeName(), this.syncStatus);
        Instant endTime = Instant.now();
        long duration = Duration.between(startTime, endTime).toMillis();
        this.syncStatus.addMessage("Building index took " + duration + " milliseconds.");
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public LinchpinEventSender getLinchpinEventSender() {
        return this.linchpinEventSender;
    }
}

