/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import com.fasterxml.jackson.databind.JsonNode;
import de.resolution.atlasuser.api.directory.AtlasUserDirectory;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.DirectoryNameExistsAlreadyException;
import de.resolution.atlasuser.api.exception.DirectoryNotFoundException;
import de.resolution.atlasuser.api.exception.InvalidOperationException;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.config.AttributeTransformationConfigValidator;
import de.resolution.usersync.api.ConnectorAndValidationResult;
import de.resolution.usersync.api.ConnectorFactoryRegistry;
import de.resolution.usersync.api.ConnectorStorageManager;
import de.resolution.usersync.api.IdentifierForSingleUserSync;
import de.resolution.usersync.api.LabelValue;
import de.resolution.usersync.api.NotificationService;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.api.exception.GeneralSyncException;
import de.resolution.usersync.impl.DirectoryIdAndName;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ConnectorService {
    public static final String CONNECTOR_UID_KEY = "CONNECTOR_UID";
    public static final String SYNCSTATUS_ID_KEY = "SYNCSTATUS_ID";

    public <K extends ConnectorConfiguration, C extends Connector<K>> C create(String var1) throws ConnectorFactoryNotAvailableException, ConfigurationFailedException;

    public <K extends ConnectorConfiguration> Connector<K> create(Class<? extends Connector<K>> var1) throws ConnectorFactoryNotAvailableException, ConfigurationFailedException;

    public void validate(ValidationResult var1, String var2, JsonNode var3, String var4);

    public ValidationResult validateIdentifierForSingleSync(IdentifierForSingleUserSync var1, String var2);

    public <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> configure(String var1, String var2) throws ConnectorNotFoundException, ConnectorFactoryNotAvailableException, ConfigurationFailedException;

    public <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> configure(String var1, K var2) throws ConnectorNotFoundException, ConnectorFactoryNotAvailableException, ConfigurationFailedException;

    @Nonnull
    public <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> getConnectorByUniqueId(String var1) throws ConnectorNotFoundException, ConnectorFactoryNotAvailableException, ConfigurationFailedException;

    @Nonnull
    public <C extends Connector<K>, K extends ConnectorConfiguration> Collection<ConnectorAndValidationResult<C, K>> getConnectors();

    @Nonnull
    public <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> reloadConnectorIntoCache(String var1) throws ConnectorNotFoundException, ConnectorFactoryNotAvailableException, ConfigurationFailedException;

    public void toggleSchedule(Connector<?> var1);

    public <K extends ConnectorConfiguration> ValidationResult validate(Connector<K> var1);

    public boolean delete(String var1);

    public String createNewUniqueId();

    public boolean directoryExists(long var1);

    public long createDirectory(String var1, String var2) throws DirectoryNameExistsAlreadyException;

    public void renameDirectory(long var1, String var3, String var4) throws DirectoryNameExistsAlreadyException, DirectoryNotFoundException, InvalidOperationException;

    public List<AtlasUserDirectory> getOrphanedDirectories();

    public void deleteOrphanedDirectory(long var1) throws InvalidOperationException, DirectoryNotFoundException, AtlasUserOperationFailedException;

    public List<LabelValue<String, String>> getAvailableConnectorNamesAndUniqueIds();

    @Nullable
    public String getConnectorUIDforLegacyId(int var1);

    public long getFirstWritableDirectoryId();

    public List<AtlasUserDirectory> getAllDirectories();

    public ConnectorStorageManager getConnectorStorageManager();

    public DirectoryIdAndName prepareDirectory(long var1, String var3, String var4) throws InvalidOperationException;

    public String makeDirectoryNameUnique(@Nonnull String var1) throws InvalidOperationException;

    public String getApplicationPrefix();

    public String getBaseUrl();

    public boolean isInitialized();

    public void initUserSyncConnectors();

    public AtlasUserAdapter getAtlasUserAdapter();

    public NotificationService getNotificationService();

    public ConnectorFactoryRegistry getConnectorFactoryRegistry();

    public AttributeTransformationConfigValidator getAttributeTransformationConfigValidator();

    public Map<String, String> fetchRequiredGroupIdsAndNames(String var1, String var2) throws ConnectorFactoryNotAvailableException, ConfigurationFailedException, ConnectorNotFoundException, GeneralSyncException;

    public Map<String, String> fetchRequiredGroupIdsAndNames(String var1, List<String> var2) throws ConnectorFactoryNotAvailableException, ConfigurationFailedException, ConnectorNotFoundException, GeneralSyncException;
}

