/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.jira;

import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
public class JiraUtil {
    private static final Logger logger = LoggerFactory.getLogger(JiraUtil.class);
    private final UserUtil userUtil;
    private final ApplicationRoleManager applicationRoleManager;
    private static final String NO_ADMIN_FOUND = "Could not find any user with Administrator- or System Administrator- privileges, user create {} operations will fail!";

    @Autowired
    public JiraUtil(@JiraImport UserUtil userUtil, @JiraImport ApplicationRoleManager applicationRoleManager) {
        this.userUtil = userUtil;
        this.applicationRoleManager = applicationRoleManager;
    }

    ApplicationUser findExecutionUser() {
        return this.findExecutionUser(false);
    }

    ApplicationUser findExecutionUser(boolean forOrganizationAssignment) {
        Iterator adminUserIterator;
        Collection adminUsers = this.userUtil.getJiraAdministrators();
        String textForLogger = "";
        if (forOrganizationAssignment) {
            textForLogger = "and/ or Jira Service Desk organization ";
        }
        if (adminUsers.isEmpty()) {
            logger.debug("Found no Administrators, checking for System Administrators");
            adminUsers = this.userUtil.getJiraSystemAdministrators();
            if (adminUsers.isEmpty()) {
                logger.error(NO_ADMIN_FOUND, (Object)textForLogger);
                return null;
            }
        }
        if (!(adminUserIterator = adminUsers.iterator()).hasNext()) {
            logger.error(NO_ADMIN_FOUND, (Object)textForLogger);
            return null;
        }
        ApplicationUser adminUser = (ApplicationUser)adminUserIterator.next();
        if (forOrganizationAssignment) {
            boolean hasJiraServiceDeskApplicationAccess = this.checkJiraServiceDeskApplicationAccess(this.applicationRoleManager.getRolesForUser(adminUser));
            while (!adminUser.isActive() || !hasJiraServiceDeskApplicationAccess) {
                if (adminUserIterator.hasNext()) {
                    adminUser = (ApplicationUser)adminUserIterator.next();
                    hasJiraServiceDeskApplicationAccess = this.checkJiraServiceDeskApplicationAccess(this.applicationRoleManager.getRolesForUser(adminUser));
                    continue;
                }
                logger.error(NO_ADMIN_FOUND, (Object)textForLogger);
                return null;
            }
        } else {
            while (!adminUser.isActive()) {
                if (adminUserIterator.hasNext()) {
                    adminUser = (ApplicationUser)adminUserIterator.next();
                    continue;
                }
                logger.error(NO_ADMIN_FOUND, (Object)"");
                return null;
            }
        }
        logger.debug("Performing operation as user '{}'", (Object)adminUser.getUsername());
        return adminUser;
    }

    private boolean checkJiraServiceDeskApplicationAccess(Set<ApplicationRole> rolesForUser) {
        if (rolesForUser == null) {
            return false;
        }
        for (ApplicationRole applicationRole : rolesForUser) {
            if (!Objects.equals("jira-servicedesk", applicationRole.getKey().toString())) continue;
            return true;
        }
        return false;
    }
}

