/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.User;
import de.resolution.atlasuser.api.directory.AtlasUserDirectory;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.atlasuser.api.exception.AtlasUserValidationFailedException;
import de.resolution.atlasuser.api.exception.UserPresentInALowerDirectoryException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.impl.user.DefaultAtlasUserValidator;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserRenamingBreaksMappingValidator
extends DefaultAtlasUserValidator {
    @Inject
    protected DirectoryAdapter directoryAdapter;
    @Inject
    protected DirectoryManager directoryManager;
    private static Logger logger = LoggerFactory.getLogger(UserRenamingBreaksMappingValidator.class);

    @Override
    public void validateForRenaming(AtlasUser atlasUser) throws AtlasUserValidationFailedException {
        super.validateForUpdate(atlasUser);
        this.requireUserNotPresentInLowerDirectoryWithSameUsername(atlasUser);
    }

    private void requireUserNotPresentInLowerDirectoryWithSameUsername(@Nonnull AtlasUser userToUpdate) throws AtlasUserValidationFailedException {
        String newName = userToUpdate.get("ATTR_NEW_NAME").orElse(userToUpdate.get("ATTR_NAME").orElse(null));
        if (newName == null) {
            throw new AtlasUserValidationFailedException(userToUpdate.getReference(), "newUsername", null, "newUsername not given");
        }
        long directoryId = userToUpdate.getReference().getDirectoryId();
        int positionOfDirectory = this.directoryAdapter.getPosition(directoryId);
        ArrayList<AtlasUserDirectory> directories = new ArrayList<AtlasUserDirectory>(this.directoryAdapter.getDirectories());
        directories.removeIf(this.getRemovePredicate(positionOfDirectory));
        for (AtlasUserDirectory curr : directories) {
            try {
                User res = this.directoryManager.findUserByName(curr.getId(), newName);
                if (res == null) continue;
                throw new UserPresentInALowerDirectoryException(userToUpdate, String.valueOf(curr.getId()), curr.getName());
            }
            catch (UserNotFoundException e) {
                logger.trace("User was not found in directory {} {}", (Object)curr.getId(), (Object)curr.getName());
            }
            catch (DirectoryNotFoundException e) {
                throw new AtlasUserValidationFailedException(userToUpdate.getReference(), "Directory", curr.getId() + curr.getName(), "Directory was not found while it was present a second ago");
            }
            catch (OperationFailedException e) {
                throw new AtlasUserValidationFailedException(userToUpdate.getReference(), "OperationFailedException", null, "This exception happened when searching through the directory " + curr.getName() + " " + curr.getName());
            }
        }
    }

    protected Predicate<AtlasUserDirectory> getRemovePredicate(int positionOfDirectory) {
        return dir -> this.directoryAdapter.getPosition(dir.getId()) <= positionOfDirectory;
    }
}

