/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.api.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface AtlasUser
extends Principal {
    public static AtlasUserBuilder builder() {
        return new AtlasUserBuilder();
    }

    default public AtlasUserBuilder newBuilder() {
        return new AtlasUserBuilder().from(this);
    }

    @Nonnull
    public AtlasUserReference getReference();

    public boolean containsKey(@Nonnull String var1);

    public Map<String, Set<String>> getAttributes();

    public boolean isEqualSuperset(AtlasUser var1, Collection<String> var2);

    default public boolean isEqualSuperset(AtlasUser other, String ... ignoreTheseAttributes) {
        return this.isEqualSuperset(other, Arrays.asList(ignoreTheseAttributes));
    }

    default public boolean isEqualSuperset(AtlasUser other) {
        return this.isEqualSuperset(other, Collections.singleton("ATLAS_USER_TIMESTAMP"));
    }

    @JsonIgnore
    default public boolean isActive() {
        return Boolean.parseBoolean(this.get("ATTR_ACTIVE").orElse("false"));
    }

    @JsonIgnore
    default public boolean isAdminOrSysAdmin() {
        return Boolean.parseBoolean(this.get("ATTR_IS_ADMIN").orElse("false")) || Boolean.parseBoolean(this.get("ATTR_IS_SYSADMIN").orElse("false"));
    }

    @Nonnull
    @JsonIgnore
    public Set<String> getAttributeKeys();

    @Nonnull
    @JsonIgnore
    public Set<String> getAttributeValues(@Nonnull String var1);

    @Nonnull
    @JsonIgnore
    default public Optional<String> get(@Nonnull String key) {
        Set<String> values2 = this.getAttributeValues(key);
        Iterator<String> it = values2.iterator();
        if (it.hasNext()) {
            return Optional.of(it.next());
        }
        return Optional.empty();
    }
}

