/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasauth.impl.bamboo;

import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.user.LoginInformationManager;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.spring.container.ContainerManager;
import de.resolution.atlasauth.impl.AbstractAuthenticatorHook;
import de.resolution.atlasauth.impl.AuthenticatorHookException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.util.JSONUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@BambooComponent(value="AuthenticatorHook")
public class BambooAuthenticatorHook
extends AbstractAuthenticatorHook {
    private final Logger logger = LoggerFactory.getLogger(BambooAuthenticatorHook.class);
    private final DefaultAuthenticator authenticator;
    private final BambooUserManager bambooUserManager;
    private final AtlasUserAdapter atlasUserAdapter;

    @Autowired
    public BambooAuthenticatorHook(@BambooImport BambooUserManager bambooUserManager, AtlasUserAdapter atlasUserAdapter) {
        this.bambooUserManager = bambooUserManager;
        this.atlasUserAdapter = atlasUserAdapter;
        Authenticator originalAuthenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        if (!(originalAuthenticator instanceof DefaultAuthenticator)) {
            throw new AuthenticatorHookException("This authenticator of type " + originalAuthenticator.getClass().getCanonicalName() + " is not a DefaultAuthenticator.");
        }
        this.authenticator = (DefaultAuthenticator)originalAuthenticator;
    }

    @Override
    protected DefaultAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public boolean doAuthoriseUserAndEstablishSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Principal principal, boolean sdCustomerLogin) {
        Class<DefaultAuthenticator> authenticatorClass = DefaultAuthenticator.class;
        if (principal == null) {
            this.logger.error("Principal must not be null!");
            return false;
        }
        BambooUser bambooUser = this.bambooUserManager.getBambooUser(principal.getName());
        if (bambooUser == null) {
            throw new AuthenticatorHookException("BambooUser is null");
        }
        if (!bambooUser.isEnabled()) {
            throw new AuthenticatorHookException("BambooUser is not enabled");
        }
        this.logger.debug("Principal name is: {}, class is: {}", (Object)principal.getName(), (Object)principal.getClass().getCanonicalName());
        try {
            String methodName = "authoriseUserAndEstablishSession";
            Class[] parameterTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Principal.class};
            Object[] parameters = new Object[]{httpServletRequest, httpServletResponse, principal};
            Method methodToInvoke = authenticatorClass.getDeclaredMethod(methodName, parameterTypes);
            methodToInvoke.setAccessible(true);
            Object returnValue = methodToInvoke.invoke((Object)this.authenticator, parameters);
            if (returnValue instanceof Boolean) {
                boolean authenticated = (Boolean)returnValue;
                this.logger.debug("authoriseUserAndEstablishSession returned {}", (Object)authenticated);
                if (authenticated) {
                    LoginInformationManager loginInformationManager = (LoginInformationManager)ContainerManager.getComponent((String)"loginInformationManager");
                    loginInformationManager.resetFailedLoginAttemptsCount(principal.getName());
                    AtlasUserResult readResult = this.atlasUserAdapter.readFirstUniqueUser(AtlasUserReference.create("ATTR_NAME", principal.getName(), -1L));
                    if (readResult.isSuccess()) {
                        Optional<AtlasUser> readUserOpt = readResult.getResultingUser();
                        AtlasUser toUpdate = AtlasUser.builder().findBy("ATTR_NAME", principal.getName()).in(readUserOpt.get().getReference().getDirectoryId()).with("lastAuthenticated", String.valueOf(System.currentTimeMillis())).build();
                        AtlasUserResult updateResult = this.atlasUserAdapter.update(toUpdate);
                        if (!updateResult.isSuccess()) {
                            if (this.logger.isWarnEnabled()) {
                                this.logger.warn("Updating {} at {} failed: {}", new Object[]{"lastAuthenticated", principal.getName(), JSONUtil.asJson(updateResult)});
                            }
                        } else if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Updated {}: {}", (Object)"lastAuthenticated", (Object)JSONUtil.asJson(readResult));
                        }
                    } else if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Reading AtlasUser for updating {} failed: {}", (Object)"lastAuthenticated", (Object)JSONUtil.asJson(readResult));
                    }
                }
                return authenticated;
            }
            throw new AuthenticatorHookException("Authenticator method did not return a boolean, but a " + returnValue.getClass().getCanonicalName());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new AuthenticatorHookException(e);
        }
        catch (InvocationTargetException e) {
            throw new AuthenticatorHookException(e.getCause());
        }
    }
}

