/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl.jira;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import de.resolution.usersync.api.SharedHomeProvider;
import de.resolution.usersync.impl.ClusterNodeInformation;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ExportAsService(value={SharedHomeProvider.class})
@JiraComponent
public class JiraClusterNodeInformation
implements ClusterNodeInformation,
SharedHomeProvider {
    private final String nodeId;
    private final File sharedHome;
    private final ClusterManager clusterManager;

    @Inject
    public JiraClusterNodeInformation(@JiraImport ClusterManager clusterManager, @JiraImport JiraHome jiraHome) {
        this.nodeId = clusterManager.isClustered() ? clusterManager.getNodeId() : "NOT_CLUSTERED";
        this.sharedHome = jiraHome.getHome();
        this.clusterManager = clusterManager;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public Set<String> getAllNodeIds() {
        if (this.nodeId.equals("NOT_CLUSTERED")) {
            return Collections.singleton("NOT_CLUSTERED");
        }
        return this.clusterManager.getAllNodes().stream().map(Node::getNodeId).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getActiveNodeIds() {
        if (this.nodeId.equals("NOT_CLUSTERED")) {
            return Collections.singleton("NOT_CLUSTERED");
        }
        return this.clusterManager.getAllNodes().stream().filter(node -> node.getState() == Node.NodeState.ACTIVE).map(Node::getNodeId).collect(Collectors.toSet());
    }

    @Override
    public File getSharedHome() {
        return this.sharedHome;
    }
}

