/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.atlasuser.api.CancelHandle;
import de.resolution.atlasuser.api.directory.AtlasUserDirectory;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.InvalidSearchFilterException;
import de.resolution.atlasuser.api.exception.UnexpectedAttributeValueException;
import de.resolution.atlasuser.api.user.ApplicationAccessAdapter;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserKeys;
import de.resolution.atlasuser.api.user.SearchFilter;
import de.resolution.atlasuser.api.user.SortBy;
import de.resolution.atlasuser.api.user.UserSearchResult;
import de.resolution.atlasuser.impl.user.ApplicationAttributeAdapter;
import de.resolution.atlasuser.impl.user.UserSearchResultEntry;
import de.resolution.atlasuser.impl.user.UserSearchResultImpl;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={UserSearcher.class})
public class UserSearcher {
    private static final Logger logger = LoggerFactory.getLogger(UserSearcher.class);
    private final DirectoryAdapter directoryAdapter;
    private final DirectoryManager directoryManager;
    private final ApplicationAccessAdapter applicationAccessAdapter;
    private final ApplicationAttributeAdapter applicationAttributeAdapter;
    public static final int DEFAULT_BATCH_SIZE = 1000;

    @Autowired
    public UserSearcher(DirectoryAdapter directoryAdapter, ApplicationAccessAdapter applicationAccessAdapter, ApplicationAttributeAdapter applicationAttributeAdapter, @ComponentImport DirectoryManager directoryManager) {
        this.directoryAdapter = directoryAdapter;
        this.applicationAccessAdapter = applicationAccessAdapter;
        this.applicationAttributeAdapter = applicationAttributeAdapter;
        this.directoryManager = directoryManager;
    }

    public UserSearchResult search(@Nonnull SearchFilter searchFilter, @Nonnull SortBy sortBy, CancelHandle cancelHandle, AtlasUserAdapter atlasUserAdapter) throws AtlasUserOperationFailedException, de.resolution.atlasuser.api.exception.DirectoryNotFoundException, InvalidSearchFilterException {
        return this.search(searchFilter, sortBy, cancelHandle, atlasUserAdapter, 1000);
    }

    @Nonnull
    public UserSearchResult search(@Nonnull SearchFilter searchFilter, @Nonnull SortBy sortBy, CancelHandle cancelHandle, AtlasUserAdapter atlasUserAdapter, int batchSize) throws AtlasUserOperationFailedException, de.resolution.atlasuser.api.exception.DirectoryNotFoundException, InvalidSearchFilterException {
        UserSearchResultImpl resultImpl = new UserSearchResultImpl(atlasUserAdapter, this.directoryManager, sortBy);
        long directoryId = searchFilter.getDirectoryId();
        if (directoryId == -1L || directoryId == -3L) {
            HashSet<String> userNamesToFilter = new HashSet<String>();
            List<AtlasUserDirectory> directories = this.directoryAdapter.getDirectories();
            for (int i = 0; i < directories.size(); ++i) {
                AtlasUserDirectory directory = directories.get(i);
                if (directory.isActive()) {
                    logger.debug("Searching in directory {} ", (Object)directory.getId());
                    try {
                        if (directoryId == -1L) {
                            resultImpl.addAll(this.search(directory.getId(), i, searchFilter, sortBy, cancelHandle, userNamesToFilter, batchSize));
                            if (i >= directories.size() - 1) continue;
                            userNamesToFilter.addAll(this.getAllUsernamesInDirectory(directory.getId(), batchSize));
                            continue;
                        }
                        resultImpl.addAll(this.search(directory.getId(), i, searchFilter, sortBy, cancelHandle, new HashSet<String>(), batchSize));
                        continue;
                    }
                    catch (OperationFailedException e) {
                        throw new AtlasUserOperationFailedException(e);
                    }
                    catch (DirectoryNotFoundException e) {
                        throw new de.resolution.atlasuser.api.exception.DirectoryNotFoundException(directoryId);
                    }
                }
                logger.debug("Skipping inactive directory {}:{}", (Object)directory.getId(), (Object)directory.getName());
            }
        } else {
            logger.debug("Searching in directory {} only", (Object)directoryId);
            try {
                resultImpl.addAll(this.search(directoryId, 0, searchFilter, sortBy, cancelHandle, new HashSet<String>(), batchSize));
            }
            catch (OperationFailedException e) {
                throw new AtlasUserOperationFailedException(e);
            }
            catch (DirectoryNotFoundException e) {
                throw new de.resolution.atlasuser.api.exception.DirectoryNotFoundException(directoryId);
            }
        }
        if (cancelHandle.isCancelled()) {
            resultImpl.cancel();
            return resultImpl;
        }
        resultImpl.sort();
        if (cancelHandle.isCancelled()) {
            resultImpl.cancel();
        }
        return resultImpl;
    }

    @Nullable
    private List<UserSearchResultEntry> search(long directoryId, int directoryOrder, @Nonnull SearchFilter searchFilter, @Nonnull SortBy sortBy, CancelHandle cancelHandle, Set<String> userNamesToFilter, int batchSize) throws OperationFailedException, DirectoryNotFoundException, InvalidSearchFilterException {
        List<String> groupMembers;
        List currentBatchUserList;
        List<UserSearchResultEntry> resultList = new ArrayList<UserSearchResultEntry>();
        int batchCount = 1;
        int startIndex = 0;
        do {
            if (cancelHandle.isCancelled()) {
                logger.warn("Cancelled while searching directory {}", (Object)directoryId);
                return null;
            }
            SearchRestriction restriction = this.createRestriction(searchFilter);
            EntityQuery userQuery = restriction != null ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with(this.createRestriction(searchFilter)).startingAt(startIndex).returningAtMost(batchSize) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(startIndex).returningAtMost(batchSize);
            currentBatchUserList = this.directoryManager.searchUsers(directoryId, userQuery);
            logger.debug("Executed batch {} starting at {} returning {} users", new Object[]{batchCount, startIndex, currentBatchUserList.size()});
            for (User crowdUser : currentBatchUserList) {
                String username = crowdUser.getName();
                if (!userNamesToFilter.contains(username)) {
                    resultList.add(new UserSearchResultEntry(crowdUser, directoryOrder, sortBy));
                    continue;
                }
                logger.debug("User {} has already been found in other directory", (Object)username);
            }
            if (cancelHandle.isCancelled()) {
                logger.warn("Cancelled while searching directory {}", (Object)directoryId);
                return null;
            }
            startIndex += batchSize;
            ++batchCount;
        } while (currentBatchUserList.size() >= batchSize);
        if (searchFilter.getIncludedUsernames() != null && !searchFilter.getIncludedUsernames().isEmpty()) {
            resultList = resultList.stream().filter(result -> searchFilter.getIncludedUsernames().contains(result.getUsername())).collect(Collectors.toList());
        }
        if (cancelHandle.isCancelled()) {
            logger.warn("Cancelled before filtering by application access");
            return null;
        }
        if (searchFilter.getApplicationAccess() != null && !searchFilter.getApplicationAccess().isEmpty()) {
            List<String> usernamesWithApplicationAccess;
            Set<String> groupsWithApplicationAccess;
            ArrayList<String> groupList = new ArrayList<String>();
            if (searchFilter.getApplicationAccess().contains("NO_APPLICATION")) {
                if (searchFilter.getApplicationAccess().size() > 1) {
                    throw new InvalidSearchFilterException("NO_APPLICATION must be the only applicationKey if used for filtering");
                }
                groupsWithApplicationAccess = this.applicationAccessAdapter.getGroupsGivingAccess("ANY_APPLICATION");
                usernamesWithApplicationAccess = this.searchGroupMemberships(directoryId, groupsWithApplicationAccess);
                usernamesWithApplicationAccess.addAll(this.applicationAccessAdapter.getUsersWithDirectAccess("ANY_APPLICATION"));
                resultList = resultList.stream().filter(entry -> !usernamesWithApplicationAccess.contains(entry.getUsername())).collect(Collectors.toList());
            } else if (searchFilter.getApplicationAccess().contains("ANY_APPLICATION")) {
                if (searchFilter.getApplicationAccess().size() > 1) {
                    throw new InvalidSearchFilterException("ANY_APPLICATION must be the only applicationKey if used for filtering");
                }
                groupsWithApplicationAccess = this.applicationAccessAdapter.getGroupsGivingAccess("ANY_APPLICATION");
                usernamesWithApplicationAccess = this.searchGroupMemberships(directoryId, groupsWithApplicationAccess);
                usernamesWithApplicationAccess.addAll(this.applicationAccessAdapter.getUsersWithDirectAccess("ANY_APPLICATION"));
                resultList = resultList.stream().filter(entry -> usernamesWithApplicationAccess.contains(entry.getUsername())).collect(Collectors.toList());
            } else {
                List<String> usersWithAccess;
                searchFilter.getApplicationAccess().forEach(applicationKey -> groupList.addAll(this.applicationAccessAdapter.getGroupsGivingAccess((String)applicationKey)));
                if (groupList.isEmpty()) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Group list for application access {} is empty in directory {}", (Object)String.join((CharSequence)",", searchFilter.getApplicationAccess()), (Object)directoryId);
                    }
                    usersWithAccess = new ArrayList<String>();
                } else {
                    usersWithAccess = this.searchGroupMemberships(directoryId, groupList);
                }
                searchFilter.getApplicationAccess().forEach(applicationKey -> usersWithAccess.addAll(this.applicationAccessAdapter.getUsersWithDirectAccess((String)applicationKey)));
                resultList = resultList.stream().filter(entry -> usersWithAccess.contains(entry.getUsername())).collect(Collectors.toList());
            }
        }
        if (cancelHandle.isCancelled()) {
            logger.warn("Cancelled before filtering by groups in directory {}", (Object)directoryId);
            return null;
        }
        if (searchFilter.getInGroups() != null && !searchFilter.getInGroups().isEmpty()) {
            groupMembers = this.searchGroupMemberships(directoryId, searchFilter.getInGroups());
            resultList = resultList.stream().filter(entry -> groupMembers.contains(entry.getUsername())).collect(Collectors.toList());
        }
        if (cancelHandle.isCancelled()) {
            logger.warn("Cancelled before filtering by not-in-group in directory {}", (Object)directoryId);
            return null;
        }
        if (searchFilter.getNotInGroups() != null && !searchFilter.getNotInGroups().isEmpty()) {
            groupMembers = this.searchGroupMemberships(directoryId, searchFilter.getNotInGroups());
            resultList = resultList.stream().filter(entry -> !groupMembers.contains(entry.getUsername())).collect(Collectors.toList());
        }
        if (cancelHandle.isCancelled()) {
            logger.warn("Cancelled before filtering by notTheseIds in directory {}", (Object)directoryId);
            return null;
        }
        if (searchFilter.getExcludedUsernames() != null && !searchFilter.getExcludedUsernames().isEmpty()) {
            resultList = resultList.stream().filter(entry -> !searchFilter.getExcludedUsernames().contains(entry.getUsername())).collect(Collectors.toList());
        }
        if (cancelHandle.isCancelled()) {
            logger.warn("Cancelled before filtering by attribute in directory {}", (Object)directoryId);
            return null;
        }
        if (searchFilter.hasAttributeFilter() || searchFilter.hasLastKnownActivity()) {
            ArrayList<UserSearchResultEntry> filtered = new ArrayList<UserSearchResultEntry>();
            for (UserSearchResultEntry entry2 : resultList) {
                try {
                    UserWithAttributes userWithAttributes = this.directoryManager.findUserWithAttributesByName(directoryId, entry2.getUsername());
                    boolean matchedAttributeFilter = searchFilter.hasAttributeFilter() && searchFilter.getAttributeFilters().stream().allMatch(attributeFilter -> {
                        HashMap<String, Set> attributeMap = new HashMap<String, Set>();
                        for (String filterAttributeName : attributeFilter.getAttributeNames()) {
                            if (filterAttributeName.equals("ATTR_EMAIL")) {
                                attributeMap.put(filterAttributeName, Collections.singleton(userWithAttributes.getEmailAddress()));
                                continue;
                            }
                            if (filterAttributeName.equals("ATTR_NAME")) {
                                attributeMap.put(filterAttributeName, Collections.singleton(userWithAttributes.getName()));
                                continue;
                            }
                            Set values2 = userWithAttributes.getValues(filterAttributeName);
                            if (values2 == null || values2.isEmpty()) continue;
                            attributeMap.put(filterAttributeName, values2);
                        }
                        return attributeFilter.getAttributeNames().stream().anyMatch(attributeName -> attributeFilter.test(attributeMap));
                    });
                    boolean matchedLastKnownActivityPresent = false;
                    boolean matchedLastKnownActivityBefore = false;
                    boolean matchedLastKnownActivityOnOrAfter = false;
                    if (searchFilter.hasLastKnownActivity()) {
                        long lastKnownActivityFromAttribute = this.getLastKnownActivityFromAttribute(userWithAttributes, searchFilter);
                        if (lastKnownActivityFromAttribute > 0L) {
                            matchedLastKnownActivityPresent = searchFilter.getLastKnownActivityPresent() != null && searchFilter.getLastKnownActivityPresent() != false;
                            matchedLastKnownActivityBefore = searchFilter.getLastKnownActivityBefore() != null && lastKnownActivityFromAttribute < searchFilter.getLastKnownActivityBefore();
                            matchedLastKnownActivityOnOrAfter = searchFilter.getLastKnownActivityOnOrAfter() != null && lastKnownActivityFromAttribute >= searchFilter.getLastKnownActivityOnOrAfter();
                        } else {
                            long lastActivityFromApplication = this.applicationAttributeAdapter.getLastAuthenticatedFromApplicationLevel((User)userWithAttributes);
                            if (lastActivityFromApplication > 0L) {
                                matchedLastKnownActivityPresent = searchFilter.getLastKnownActivityPresent() != null && searchFilter.getLastKnownActivityPresent() != false;
                                matchedLastKnownActivityBefore = searchFilter.getLastKnownActivityBefore() != null && lastActivityFromApplication < searchFilter.getLastKnownActivityBefore();
                                matchedLastKnownActivityOnOrAfter = searchFilter.getLastKnownActivityOnOrAfter() != null && lastActivityFromApplication >= searchFilter.getLastKnownActivityOnOrAfter();
                            } else {
                                boolean bl = matchedLastKnownActivityPresent = searchFilter.getLastKnownActivityPresent() != null && searchFilter.getLastKnownActivityPresent() == false;
                            }
                        }
                    }
                    if (searchFilter.hasAttributeFilter() && !matchedAttributeFilter || searchFilter.getLastKnownActivityPresent() != null && !matchedLastKnownActivityPresent || searchFilter.getLastKnownActivityBefore() != null && !matchedLastKnownActivityBefore || searchFilter.getLastKnownActivityOnOrAfter() != null && !matchedLastKnownActivityOnOrAfter) continue;
                    filtered.add(entry2);
                }
                catch (UserNotFoundException e) {
                    logger.warn("User {} was not found in directory {} and is filtered out of the result.", (Object)entry2.getUsername(), (Object)directoryId);
                }
            }
            resultList = filtered;
        }
        return resultList;
    }

    @Nonnull
    public Set<String> getAllUsernamesInDirectory(long directoryId, int batchSize) throws DirectoryNotFoundException, OperationFailedException {
        int lastBatchResultSize;
        HashSet<String> userNameList = new HashSet<String>();
        int startIndex = 0;
        do {
            EntityQuery userQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(startIndex).returningAtMost(batchSize);
            List userList = this.directoryManager.searchUsers(directoryId, userQuery);
            Set listFromBatch = userList.stream().map(Principal::getName).collect(Collectors.toSet());
            userNameList.addAll(listFromBatch);
            lastBatchResultSize = listFromBatch.size();
            startIndex += lastBatchResultSize;
        } while (lastBatchResultSize == batchSize);
        return userNameList;
    }

    @Nullable
    private SearchRestriction createRestriction(SearchFilter searchFilter) {
        ArrayList<Object> searchRestrictions = new ArrayList<Object>();
        if (searchFilter.getBaseAttributesContain() != null) {
            searchRestrictions.add(Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchFilter.getBaseAttributesContain()), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchFilter.getBaseAttributesContain()), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchFilter.getBaseAttributesContain())}));
        }
        if (searchFilter.getActivityState() != null) {
            searchRestrictions.add(Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)searchFilter.getActivityState()));
        }
        if (searchRestrictions.isEmpty()) {
            return null;
        }
        return Combine.allOf(searchRestrictions);
    }

    private List<String> searchGroupMemberships(long directoryId, Collection<String> groupNames) throws DirectoryNotFoundException, OperationFailedException {
        if (this.applicationAttributeAdapter.canSearchMembershipsForMultipleGroups()) {
            return this.searchGroupMembershipsWithSingleQuery(directoryId, groupNames);
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String groupName : groupNames) {
            logger.debug("Loading members of group {}", (Object)groupName);
            List<String> currentMembers = this.searchGroupMembershipsWithSingleQuery(directoryId, Collections.singleton(groupName));
            for (String member : currentMembers) {
                if (ret.contains(member)) continue;
                ret.add(member);
            }
        }
        return ret;
    }

    private List<String> searchGroupMembershipsWithSingleQuery(long directoryId, Collection<String> groupNames) throws DirectoryNotFoundException, OperationFailedException {
        if (groupNames == null || groupNames.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] groupNameArray = new String[groupNames.size()];
        groupNames.toArray(groupNameArray);
        MembershipQuery groupQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames(groupNameArray).returningAtMost(Integer.MAX_VALUE);
        return this.directoryManager.searchDirectGroupRelationships(directoryId, groupQuery);
    }

    public long getLastKnownActivityFromAttribute(UserWithAttributes userWithAttributes, SearchFilter searchFilter) throws InvalidSearchFilterException {
        long retValue = AtlasUserKeys.NO_TIMESTAMP_AVAILABLE;
        for (String attribute : searchFilter.getAttributesForLastKnownActivity()) {
            retValue = Math.max(this.readLongAttribute(userWithAttributes, attribute), retValue);
        }
        return retValue;
    }

    private long readLongAttribute(UserWithAttributes userWithAttributes, String key) throws UnexpectedAttributeValueException {
        String stringValue = userWithAttributes.getValue(key);
        if (stringValue == null) {
            return AtlasUserKeys.NO_TIMESTAMP_AVAILABLE;
        }
        try {
            return Long.parseLong(stringValue);
        }
        catch (NumberFormatException e) {
            throw new UnexpectedAttributeValueException("Could not parse long from " + stringValue + " read from key " + key + " on user " + userWithAttributes.getName() + " from directory " + userWithAttributes.getDirectoryId());
        }
    }
}

