/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import de.resolution.atlasuser.impl.user.PermissionChecker;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
@ConfluenceComponent
@BambooComponent
public class SalPermissionChecker
implements PermissionChecker {
    private final UserManager salUserManager;

    @Autowired
    public SalPermissionChecker(@JiraImport @ConfluenceImport @BambooImport UserManager salUserManager) {
        this.salUserManager = salUserManager;
    }

    @Override
    public boolean isAdmin(@Nonnull String username) throws UserNotFoundException {
        UserProfile userProfile = this.salUserManager.getUserProfile(username);
        if (userProfile != null) {
            UserKey userKey = userProfile.getUserKey();
            return this.salUserManager.isAdmin(userKey);
        }
        throw new UserNotFoundException("Could not load userProfile for " + username);
    }

    @Override
    public boolean isSysAdmin(@Nonnull String username) throws UserNotFoundException {
        UserProfile userProfile = this.salUserManager.getUserProfile(username);
        if (userProfile != null) {
            UserKey userKey = userProfile.getUserKey();
            return this.salUserManager.isSystemAdmin(userKey);
        }
        throw new UserNotFoundException("Could not load userProfile for " + username);
    }
}

