/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import de.resolution.atlasuser.api.user.AttributeFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAttributeFilter
implements AttributeFilter {
    protected final List<String> attributeNames;

    protected AbstractAttributeFilter(String ... attributeNames) {
        this.attributeNames = Collections.unmodifiableList(Arrays.asList(attributeNames));
    }

    @Override
    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    public static class NotEmptyAttributeFilter
    extends AbstractAttributeFilter {
        public NotEmptyAttributeFilter(String ... attributeNames) {
            super(attributeNames);
        }

        @Override
        public boolean test(Map<String, Set<String>> valueMap) {
            return this.attributeNames.stream().allMatch(key -> {
                Set values2 = (Set)valueMap.get(key);
                if (values2 != null && !values2.isEmpty()) {
                    return !((String)values2.iterator().next()).isEmpty();
                }
                return false;
            });
        }
    }

    public static class NotPresentAttributeFilter
    extends AbstractAttributeFilter {
        public NotPresentAttributeFilter(String ... attributeNames) {
            super(attributeNames);
        }

        @Override
        public boolean test(Map<String, Set<String>> valueMap) {
            return this.attributeNames.stream().noneMatch(valueMap::containsKey);
        }
    }

    public static class PresentAttributeFilter
    extends AbstractAttributeFilter {
        public PresentAttributeFilter(String ... attributeNames) {
            super(attributeNames);
        }

        @Override
        public boolean test(Map<String, Set<String>> valueMap) {
            return this.attributeNames.stream().allMatch(valueMap::containsKey);
        }
    }
}

