/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlascompat.jira73;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import de.resolution.atlascompat.api.exception.AtlasCompatApiException;
import de.resolution.atlascompat.jira.JiraPlatformApiBase;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraPlatform73Api
extends JiraPlatformApiBase {
    private static final Logger logger = LoggerFactory.getLogger(JiraPlatform73Api.class);
    private final ApplicationManager applicationManager = this.getComponent(ApplicationManager.class);
    private final UserManager userManager = this.getComponent(UserManager.class);
    private final LicenseCountService licenseCountService = this.getComponent(LicenseCountService.class);

    public JiraPlatform73Api() throws AtlasCompatApiException {
        super(Arrays.asList(ApplicationManager.class, UserManager.class));
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    public <T> T getComponent(Class<T> clazz) {
        try {
            return (T)ComponentAccessor.getOSGiComponentInstanceOfType(clazz);
        }
        catch (NoClassDefFoundError e) {
            logger.error("Component {} not found", (Object)clazz.getName());
            return null;
        }
    }

    @Override
    public boolean isApplicationInstalled(String applicationKey) {
        return this.applicationManager.getApplication(ApplicationKey.valueOf((String)applicationKey)).isDefined();
    }

    @Override
    public Optional<String> getApplicationVersion(String applicationKey) {
        Option application = this.applicationManager.getApplication(ApplicationKey.valueOf((String)applicationKey));
        if (application.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((Application)application.get()).getVersion());
    }

    @Override
    public Optional<String> getUserKeyByName(String userName) throws AtlasCompatApiException {
        try {
            ApplicationUser user = this.userManager.getUserByName(userName);
            if (user == null) {
                return Optional.empty();
            }
            return Optional.of(user.getKey());
        }
        catch (Exception e) {
            throw new AtlasCompatApiException("Exception while trying to get user key for name", e);
        }
    }

    @Override
    public int getTotalBillableUsers() {
        return this.licenseCountService.totalBillableUsers();
    }

    @Override
    public void flushBillableUsersCache() {
        this.licenseCountService.flushBillableUsersCache();
    }
}

