/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.resolution.commons.util.Elvis;
import de.resolution.commons.util.PasswordUtil;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.usersync.builtin.scim.ScimConnector;
import de.resolution.usersync.builtin.scim.ScimConnectorConfiguration;
import de.resolution.usersync.spi.AbstractConnectorConfigurationImpl;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class ScimConnectorConfigurationImpl
extends AbstractConnectorConfigurationImpl
implements ScimConnectorConfiguration {
    private static final List<AttributeTransformationConfig> DEFAULT_TRANSFORMATION_CONFIGS = new ArrayList<AttributeTransformationConfig>();
    @Nonnull
    private AuthMethod authMethod = AuthMethod.TOKEN;
    @Nonnull
    private String token = PasswordUtil.generateSecureRandomToken();
    @Nonnull
    private List<String> allowedIPs = new ArrayList<String>();

    public ScimConnectorConfigurationImpl() {
    }

    public ScimConnectorConfigurationImpl(ScimConnectorConfiguration other) {
        super(other);
        this.setAuthMethod(other.getAuthMethod());
        this.setToken(other.getToken());
        this.setAllowedIPs(other.getAllowedIPs());
    }

    @Override
    @Nonnull
    public String getDefaultFindByAttributeName() {
        return "SCIM_EXTERNAL_ID";
    }

    @Override
    @Nonnull
    public List<AttributeTransformationConfig> createDefaultAttributeTransformationConfigs() {
        return DEFAULT_TRANSFORMATION_CONFIGS;
    }

    @Override
    @Nonnull
    public ScimConnectorConfigurationImpl sanitize() {
        ScimConnectorConfigurationImpl copy = new ScimConnectorConfigurationImpl(this);
        copy.setToken("<<SENSITIVE DATA REMOVED>>");
        return copy;
    }

    @Override
    public Class<? extends Connector<? extends ConnectorConfiguration>> tellConnectorClass() {
        return ScimConnector.class;
    }

    @Override
    @Nonnull
    public AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(@Nullable AuthMethod authMethod) {
        this.authMethod = Elvis.ifNull(authMethod, AuthMethod.TOKEN);
    }

    @Override
    @Nonnull
    public String getToken() {
        return this.token;
    }

    public void setToken(@Nullable String token) {
        this.token = Elvis.ifNull(token, PasswordUtil.generateSecureRandomToken());
    }

    @Override
    @Nonnull
    public List<String> getAllowedIPs() {
        return this.allowedIPs;
    }

    public void setAllowedIPs(@Nullable List<String> allowedIPs) {
        this.allowedIPs = Elvis.ifNull(allowedIPs, new ArrayList());
    }

    static {
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle("externalId"), new Target(Target.Type.CROWD, "SCIM_EXTERNAL_ID"), true, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle("userName"), new Target(Target.Type.SYSTEM, "ATTR_NAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle("displayName"), new Target(Target.Type.SYSTEM, "ATTR_FULLNAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createGroovy("if(con.containsKey(\"emails\")) {\n    var first_email = null\n    for(email in con.emails) {\n        if(first_email == null) {\n            first_email = email.value\n        }\n        if(email.type.equals(\"work\")) {\n            return email.value\n        }\n    }    \n    if(first_email != null) {\n        return first_email\n    }\n}\nreturn userName"), new Target(Target.Type.SYSTEM, "ATTR_EMAIL"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createGroovy("if(con.containsKey(\"groups\")) {\n    return con.groups.collect {it.value}    \n}\nreturn DROP"), new Target(Target.Type.SYSTEM, "ATTR_GROUPS"), false, false));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle("active"), new Target(Target.Type.SYSTEM, "ATTR_ACTIVE"), false, true));
    }

    public static enum AuthMethod {
        BASIC,
        TOKEN;

    }
}

