/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api.cleanup;

import de.resolution.atlasuser.api.AtlasUserStatusObject;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserFunction;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.ExceptionToResultBuilderMapper;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;
import de.resolution.usersync.api.cleanup.CleanupBehaviour;
import de.resolution.usersync.api.cleanup.CleanupDecider;
import de.resolution.usersync.api.cleanup.UserCleanup;
import java.util.Collection;
import java.util.Optional;

public class CleanupFunction
extends UserCleanup
implements AtlasUserFunction {
    private final long minimalTimestamp;
    private final CleanupDecider cleanupDecider;

    public CleanupFunction(long minimalTimestamp, CleanupBehaviour behaviour, CleanupDecider cleanupDecider, AtlasUserAdapter atlasUserAdapter, Collection<String> knownAttributes, boolean removeAllGroupAssignmentsOnCleanup) {
        super(behaviour, atlasUserAdapter, knownAttributes, removeAllGroupAssignmentsOnCleanup);
        this.minimalTimestamp = minimalTimestamp;
        this.cleanupDecider = cleanupDecider;
    }

    @Override
    public Optional<AtlasUserResult> apply(AtlasUser atlasUser, AtlasUserStatusObject atlasUserStatusObject) {
        AtlasUserResult resultToReturn;
        AtlasUserResultBuilder resultBuilder = AtlasUserResult.builder(atlasUser.getReference()).initialUser(atlasUser);
        long timestamp = Long.parseLong(atlasUser.get("ATLAS_USER_TIMESTAMP").orElse("0"));
        try {
            if (!this.cleanupDecider.shouldCleanup(atlasUser, this.minimalTimestamp)) {
                return Optional.empty();
            }
            resultToReturn = super.cleanupUser(atlasUser, resultBuilder, timestamp);
        }
        catch (Exception e) {
            resultToReturn = ExceptionToResultBuilderMapper.map(resultBuilder, e).build();
        }
        atlasUserStatusObject.add(resultToReturn);
        return Optional.ofNullable(resultToReturn);
    }

    public static class UnexpectedBehaviourException
    extends RuntimeException {
        public UnexpectedBehaviourException(CleanupBehaviour cleanupBehaviour) {
            super("Unexpected behaviour " + cleanupBehaviour.toString());
        }
    }
}

