/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jsonpatch.diff.JsonDiff;
import de.resolution.commons.util.JSONUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DiffUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();

    private DiffUtil() {
    }

    @Nonnull
    public static List<Change> diff(@Nonnull Object oldObject, @Nonnull Object newObject) {
        return DiffUtil.diff(objectMapper.valueToTree(oldObject), objectMapper.valueToTree(newObject));
    }

    @Nonnull
    public static List<Change> diff(@Nonnull String oldJsonString, @Nonnull String newJsonString) {
        return DiffUtil.diff(JSONUtil.asJsonNode(oldJsonString), JSONUtil.asJsonNode(newJsonString));
    }

    @Nonnull
    public static List<Change> diff(@Nonnull JsonNode oldNode, @Nonnull JsonNode newNode) {
        try {
            ArrayList<Change> changeList = new ArrayList<Change>();
            JsonNode diff = JsonDiff.asJson(oldNode, newNode);
            if (!diff.isArray()) {
                throw new DiffException("JsonDiff returned no array!");
            }
            ArrayNode diffArray = (ArrayNode)diff;
            Iterator<JsonNode> elements = diffArray.elements();
            block16: while (elements.hasNext()) {
                JsonNode jsonNode = elements.next();
                String op = Objects.requireNonNull(jsonNode.get("op")).asText();
                String path = Objects.requireNonNull(jsonNode.get("path")).asText();
                String value = DiffUtil.asString(jsonNode.get("value"));
                String oldValue = DiffUtil.asString(oldNode.at(path));
                switch (op) {
                    case "replace": {
                        changeList.add(new Change(path, oldValue, value));
                        continue block16;
                    }
                    case "add": {
                        changeList.add(new Change(path, null, value));
                        continue block16;
                    }
                    case "remove": {
                        changeList.add(new Change(path, oldValue, null));
                        continue block16;
                    }
                    case "move": {
                        DiffUtil.trackMove(oldNode, jsonNode, changeList);
                        continue block16;
                    }
                    case "copy": {
                        DiffUtil.trackCopy(oldNode, jsonNode, changeList);
                        continue block16;
                    }
                }
                throw new DiffException("Unexpected op " + op + " in diff " + diff.asText());
            }
            return changeList;
        }
        catch (Exception e) {
            throw new DiffException(e);
        }
    }

    private static void trackCopy(JsonNode oldDataNode, JsonNode diffNodeWithCopy, List<Change> changeList) {
        String oldPath = diffNodeWithCopy.get("from").asText();
        String newPath = diffNodeWithCopy.get("path").asText();
        JsonNode valueNode = oldDataNode.at(oldPath);
        String value = valueNode != null ? valueNode.asText() : null;
        changeList.add(new Change(newPath, null, value));
    }

    private static void trackMove(JsonNode oldDataNode, JsonNode diffNodeWithMove, List<Change> changeList) {
        String oldPath = diffNodeWithMove.get("from").asText();
        String newPath = diffNodeWithMove.get("path").asText();
        JsonNode valueNode = oldDataNode.at(oldPath);
        String value = valueNode != null ? valueNode.asText() : null;
        changeList.add(new Change(oldPath, value, null));
        changeList.add(new Change(newPath, null, value));
    }

    @Nullable
    public static String asString(@Nullable JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        if (jsonNode.isTextual()) {
            return jsonNode.asText();
        }
        try {
            return objectWriter.writeValueAsString(jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new DiffException(e);
        }
    }

    public static class DiffException
    extends RuntimeException {
        public DiffException(Throwable cause) {
            super(cause);
        }

        public DiffException(String message) {
            super(message);
        }
    }

    public static class Change {
        private final String path;
        private final String from;
        private final String to;

        public Change(@Nonnull String path, @Nullable String from, @Nullable String to) {
            this.path = path;
            this.from = from;
            this.to = to;
        }

        @Nonnull
        public String getPath() {
            return this.path;
        }

        @Nullable
        public String getFrom() {
            return this.from;
        }

        @Nullable
        public String getTo() {
            return this.to;
        }
    }
}

