/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.group;

import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.group.AtlasGroup;
import de.resolution.atlasuser.api.group.AtlasGroupReference;
import de.resolution.atlasuser.api.group.AtlasGroupResult;
import de.resolution.atlasuser.impl.group.ImmutableAtlasGroupResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AtlasGroupResultBuilder {
    private final AtlasGroupReference atlasGroupReference;
    private boolean success = true;
    private AtlasGroupResult.Operation operation = AtlasGroupResult.Operation.NOT_MODIFIED;
    private AtlasGroup inputGroup;
    private AtlasGroup initialGroup;
    private AtlasGroup resultingGroup;
    private AtlasGroupResult.ErrorType errorType;
    private List<String> messages = new ArrayList<String>();
    private ExceptionInfo exceptionInfo;

    public AtlasGroupResultBuilder(AtlasGroupReference atlasGroupReference) {
        this.atlasGroupReference = atlasGroupReference;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFailure() {
        return !this.success;
    }

    public AtlasGroupResultBuilder operation(AtlasGroupResult.Operation operation) {
        this.operation = operation;
        return this;
    }

    public AtlasGroupResult.Operation getOperation() {
        return this.operation;
    }

    public AtlasGroupResultBuilder inputGroup(AtlasGroup inputGroup) {
        this.inputGroup = inputGroup;
        return this;
    }

    public AtlasGroupResultBuilder initialGroup(AtlasGroup initialGroup) {
        this.initialGroup = initialGroup;
        return this;
    }

    public AtlasGroupResultBuilder resultingGroup(AtlasGroup resultingGroup) {
        this.resultingGroup = resultingGroup;
        return this;
    }

    public AtlasGroupResultBuilder errorType(AtlasGroupResult.ErrorType errorType) {
        this.errorType = errorType;
        this.success = false;
        return this;
    }

    public AtlasGroupResultBuilder errorString(String errorString) {
        this.addMessage(errorString);
        this.success = false;
        return this;
    }

    public AtlasGroupResultBuilder addMessage(String message) {
        this.messages.add(message);
        return this;
    }

    public AtlasGroupResultBuilder messages(List<String> messages) {
        this.messages = new ArrayList<String>(messages);
        return this;
    }

    public AtlasGroupResultBuilder exceptionInfo(ExceptionInfo exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
        this.success = false;
        if (this.messages.isEmpty()) {
            this.messages.add(exceptionInfo.getMessage());
        }
        if (this.errorType == null) {
            this.errorType = AtlasGroupResult.ErrorType.OPERATION_FAILED;
        }
        return this;
    }

    public AtlasGroupResult build() {
        Objects.requireNonNull(this.atlasGroupReference);
        return new ImmutableAtlasGroupResult(this.atlasGroupReference, this.success, this.operation, this.inputGroup, this.initialGroup, this.resultingGroup, this.errorType, this.messages, this.exceptionInfo);
    }
}

