/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.exception.AtlasUserNotUniqueException;
import de.resolution.atlasuser.api.exception.AttributeNotSearchableException;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;

public class ExceptionToResultBuilderMapper {
    private ExceptionToResultBuilderMapper() {
    }

    public static AtlasUserResultBuilder map(AtlasUserResultBuilder resultBuilder, Exception e) {
        if (e instanceof UserNotFoundException) {
            return resultBuilder.errorString(e.getMessage()).errorType(AtlasUserResult.ErrorType.NOT_FOUND);
        }
        if (e instanceof DirectoryNotFoundException) {
            DirectoryNotFoundException de = (DirectoryNotFoundException)e;
            return resultBuilder.errorString("Directory " + de.getDirectoryName() + ":" + de.getId() + " was not found").errorType(AtlasUserResult.ErrorType.DIRECTORY_NOT_FOUND);
        }
        if (e instanceof AtlasUserNotUniqueException) {
            return resultBuilder.errorString("User is not unique").errorType(AtlasUserResult.ErrorType.NOT_UNIQUE);
        }
        if (e instanceof AttributeNotSearchableException) {
            return resultBuilder.errorString(e.getMessage()).errorType(AtlasUserResult.ErrorType.INVALID_SEARCH_ATTRIBUTE);
        }
        return resultBuilder.exceptionInfo(ExceptionInfo.from(e)).errorString(e.getMessage()).errorType(AtlasUserResult.ErrorType.OPERATION_FAILED);
    }
}

