/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.albauth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.albauth.Defaults;
import de.resolution.atlasauth.api.AuthenticationConfiguration;
import de.resolution.reconfigure.api.Configuration;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class AlbAuthenticationConfiguration
implements Configuration,
AuthenticationConfiguration {
    private final int version;
    private final OidcType oidcType;
    private final String tokenHeaderName;
    private final String userNameClaim;
    private final boolean verifyJwt;
    private final boolean verifyIssuer;
    private final String issuerUrl;
    private final boolean verifyArn;
    private final String arn;
    private final boolean fetchFromRemoteDirectory;
    private final boolean triggerUpdateOnCrowdDirectories;
    private final List<String> allowedIpRanges;
    private final List<String> injectAuthenticationUrls;
    private final boolean skipLogin;
    private final String skipHeaderName;
    private final boolean checkIal;
    private final int ialLevel;
    private boolean updateWithUserSync = false;
    private String userSyncConnectorUID = "None";
    private AttributeTransformationConfig userSyncLookupTransformation = AttributeTransformationConfig.create("upn", Target.Type.NONE, "US_LOOKUP");
    private final boolean showErrorPage;
    private final String errorPageTemplate;
    private final boolean removeAwsCookieOnLogout;
    private final boolean redirectOnLogout;
    private final String redirectTargetOnLogout;
    private final List<String> noInjectUrls;

    @JsonCreator
    public AlbAuthenticationConfiguration(@JsonProperty(value="oidcType") OidcType oidcType, @JsonProperty(value="tokenHeaderName") String tokenHeaderName, @JsonProperty(value="userNameClaim") String userNameClaim, @JsonProperty(value="verifyJwt") boolean verifyJwt, @JsonProperty(value="verifyIssuer") boolean verifyIssuer, @JsonProperty(value="issuerUrl") String issuerUrl, @JsonProperty(value="verifyArn") boolean verifyArn, @JsonProperty(value="arn") String arn, @JsonProperty(value="fetchFromRemoteDirectory") boolean fetchFromRemoteDirectory, @JsonProperty(value="triggerUpdateOnCrowdDirectories") boolean triggerUpdateOnCrowdDirectories, @JsonProperty(value="allowedIpRanges") List<String> allowedIpRanges, @JsonProperty(value="injectAuthenticationUrls") List<String> injectAuthenticationUrls, @JsonProperty(value="skipLogin") boolean skipLogin, @JsonProperty(value="skipHeaderName") String skipHeaderName, @JsonProperty(value="checkIal") boolean checkIal, @JsonProperty(value="ialLevel") int ialLevel, @JsonProperty(value="updateWithUserSync") boolean updateWithUserSync, @JsonProperty(value="userSyncConnectorUID") String userSyncConnectorUID, @JsonProperty(value="userSyncLookupTransformation") AttributeTransformationConfig userSyncLookupTransformation, @JsonProperty(value="showErrorPage") boolean showErrorPage, @JsonProperty(value="errorPageTemplate") String errorPageTemplate, @JsonProperty(value="removeAwsCookieOnLogout") boolean removeAwsCookieOnLogout, @JsonProperty(value="redirectOnLogout") boolean redirectOnLogout, @JsonProperty(value="redirectTargetOnLogout") String redirectTargetOnLogout, @JsonProperty(value="noInjectUrls") List<String> noInjectUrls, @JsonProperty(value="version") int version) {
        this.oidcType = oidcType;
        this.tokenHeaderName = tokenHeaderName;
        this.userNameClaim = userNameClaim;
        this.verifyJwt = verifyJwt;
        this.verifyIssuer = verifyIssuer;
        this.issuerUrl = issuerUrl;
        this.verifyArn = verifyArn;
        this.arn = arn;
        this.fetchFromRemoteDirectory = fetchFromRemoteDirectory;
        this.triggerUpdateOnCrowdDirectories = triggerUpdateOnCrowdDirectories;
        this.allowedIpRanges = allowedIpRanges != null ? new ArrayList<String>(allowedIpRanges) : Collections.emptyList();
        this.injectAuthenticationUrls = injectAuthenticationUrls != null ? new ArrayList<String>(injectAuthenticationUrls) : Collections.emptyList();
        this.skipLogin = skipLogin;
        this.skipHeaderName = skipHeaderName;
        this.checkIal = checkIal;
        this.ialLevel = ialLevel;
        this.updateWithUserSync = updateWithUserSync;
        this.userSyncConnectorUID = userSyncConnectorUID;
        this.userSyncLookupTransformation = userSyncLookupTransformation;
        this.showErrorPage = showErrorPage;
        this.errorPageTemplate = errorPageTemplate;
        this.removeAwsCookieOnLogout = removeAwsCookieOnLogout;
        this.redirectOnLogout = redirectOnLogout;
        this.redirectTargetOnLogout = redirectTargetOnLogout;
        this.noInjectUrls = noInjectUrls == null || noInjectUrls.isEmpty() ? new ArrayList<String>(Defaults.getNoInjectUrls()) : new ArrayList<String>(noInjectUrls);
        this.version = version;
    }

    @Nullable
    public OidcType getOidcType() {
        return this.oidcType;
    }

    @Nullable
    public String getTokenHeaderName() {
        return this.tokenHeaderName;
    }

    @Nullable
    public String getUserNameClaim() {
        return this.userNameClaim;
    }

    public boolean isVerifyJwt() {
        return this.verifyJwt;
    }

    public boolean isVerifyIssuer() {
        return this.verifyIssuer;
    }

    @Nullable
    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    public boolean isVerifyArn() {
        return this.verifyArn;
    }

    @Nullable
    public String getArn() {
        return this.arn;
    }

    @Nullable
    public List<String> getAllowedIpRanges() {
        return Collections.unmodifiableList(this.allowedIpRanges);
    }

    @Nonnull
    public List<String> getInjectAuthenticationUrls() {
        return Collections.unmodifiableList(this.injectAuthenticationUrls);
    }

    public boolean isSkipLogin() {
        return this.skipLogin;
    }

    @Nullable
    public String getSkipHeaderName() {
        return this.skipHeaderName;
    }

    public boolean isCheckIal() {
        return this.checkIal;
    }

    public int getIalLevel() {
        return this.ialLevel;
    }

    @Override
    public boolean isFetchFromRemoteDirectory() {
        return this.fetchFromRemoteDirectory;
    }

    @Override
    public boolean isTriggerUpdateOnCrowdDirectories() {
        return this.triggerUpdateOnCrowdDirectories;
    }

    public boolean isUpdateWithUserSync() {
        return this.updateWithUserSync;
    }

    @Nullable
    public String getUserSyncConnectorUID() {
        return this.userSyncConnectorUID;
    }

    @Nullable
    public AttributeTransformationConfig getUserSyncLookupTransformation() {
        return this.userSyncLookupTransformation;
    }

    public boolean isShowErrorPage() {
        return this.showErrorPage;
    }

    @Nullable
    public String getErrorPageTemplate() {
        return this.errorPageTemplate;
    }

    public boolean isRemoveAwsCookieOnLogout() {
        return this.removeAwsCookieOnLogout;
    }

    public boolean isRedirectOnLogout() {
        return this.redirectOnLogout;
    }

    @Nullable
    public String getRedirectTargetOnLogout() {
        return this.redirectTargetOnLogout;
    }

    public int getVersion() {
        return this.version;
    }

    @Nonnull
    public List<String> getNoInjectUrls() {
        return Collections.unmodifiableList(this.noInjectUrls);
    }

    public static enum OidcType {
        AZURE,
        OKTA,
        GSUITE,
        COGNITO,
        OTHER;

    }
}

