/*
 * Decompiled with CFR 0.152.
 */
package de.edrup.confluence.plugins.attachmentboxes.util;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AttachmentBoxesHelper {
    private final AttachmentManager attachmentMan;
    private final PageManager pageMan;
    private final LabelManager labelMan;
    private final TransactionTemplate transactionTemplate;
    private final PluginLicenseManager licenseMan;
    private final Cache<String, String> potentialLabelActionCache;
    private final PermissionManager permissionMan;
    private static ExecutorService pool = Executors.newFixedThreadPool(4);
    private static final Logger log = LoggerFactory.getLogger(AttachmentBoxesHelper.class);

    @Inject
    public AttachmentBoxesHelper(@ComponentImport CacheManager cacheManager, @ComponentImport AttachmentManager attachmentMan, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport LabelManager labelMan, @ComponentImport PluginLicenseManager licenseMan, @ComponentImport PageManager pageMan, @ComponentImport PermissionManager permissionMan) {
        this.potentialLabelActionCache = cacheManager.getCache("Attachment Boxes action cache", null, new CacheSettingsBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build());
        this.attachmentMan = attachmentMan;
        this.transactionTemplate = transactionTemplate;
        this.labelMan = labelMan;
        this.licenseMan = licenseMan;
        this.pageMan = pageMan;
        this.permissionMan = permissionMan;
    }

    public void addToCache(Long pageId, String userKey, String fileNameHash, String labelsToAdd, Long uploadToPage, Boolean dropOldLabels) {
        List<String> hashes = Arrays.asList(fileNameHash.split(","));
        for (String hash : hashes) {
            log.debug("Adding the following potential label action to the cache: {}, {}, {}, {}, {}, {}", new Object[]{pageId, userKey, hash, labelsToAdd, uploadToPage, dropOldLabels});
            this.potentialLabelActionCache.put((Object)this.createCacheKey(pageId, userKey, hash), (Object)new JSONObject().put("labelsToAdd", labelsToAdd).put("uploadToPage", uploadToPage).put("dropOldLabels", dropOldLabels).toString());
        }
    }

    private String createCacheKey(Long pageId, String userKey, String hash) {
        return pageId.toString() + ":" + userKey + ":" + hash;
    }

    public void handleAttachmentUploadEvent(Long pageId, Long attachmentId) {
        this.transactionTemplate.execute(() -> this.handleAttachmentUploadEventInTransaction(pageId, attachmentId));
    }

    private boolean handleAttachmentUploadEventInTransaction(Long pageId, Long attachmentId) {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            log.error(e.toString());
        }
        Attachment attachment = this.attachmentMan.getAttachment(attachmentId.longValue());
        String cacheKey = this.createCacheKey(pageId, attachment.getLastModifier().getKey().toString(), Integer.toString(attachment.getTitle().hashCode()));
        String potentialLabelAction = (String)this.potentialLabelActionCache.get((Object)cacheKey);
        log.debug("Handling attachment upload event: {}, {}, {}", new Object[]{pageId, attachmentId, attachment.getLastModifier().getKey().toString()});
        if (potentialLabelAction != null) {
            String[] labelsToAdd;
            log.debug("Label action found in cache: {}, {}, {}", new Object[]{pageId, attachmentId, potentialLabelAction});
            JSONObject potentialLabelActionJSON = new JSONObject(potentialLabelAction);
            if (potentialLabelActionJSON.has("dropOldLabels") && potentialLabelActionJSON.getBoolean("dropOldLabels")) {
                log.debug("Removing all previous labels for attachment with id {}", (Object)attachmentId);
                this.labelMan.removeAllLabels((Labelable)attachment);
            }
            for (String labelToAdd : labelsToAdd = potentialLabelActionJSON.getString("labelsToAdd").split(" *, *")) {
                if (labelToAdd.isEmpty()) continue;
                log.debug("Adding label {} to attachment with id {}", (Object)labelToAdd, (Object)attachmentId);
                this.labelMan.addLabel((Labelable)attachment, new Label(labelToAdd));
            }
            if (!pageId.equals(potentialLabelActionJSON.getLong("uploadToPage"))) {
                CompletableFuture.supplyAsync(() -> this.delayedMove(attachmentId, potentialLabelActionJSON.getLong("uploadToPage")), pool);
            }
            this.potentialLabelActionCache.remove((Object)cacheKey);
            return true;
        }
        return false;
    }

    private boolean delayedMove(Long attachmentId, Long toPageId) {
        try {
            Thread.sleep(200L);
            log.debug("Moving attachment {} to page {}", (Object)attachmentId, (Object)toPageId);
            this.transactionTemplate.execute(() -> this.moveAttachment(attachmentId, toPageId));
            return true;
        }
        catch (Exception e) {
            log.error(e.toString());
            return false;
        }
    }

    private boolean moveAttachment(Long attachmentId, Long toPageId) {
        this.attachmentMan.moveAttachment(this.attachmentMan.getAttachment(attachmentId.longValue()), this.attachmentMan.getAttachment(attachmentId.longValue()).getFileName(), (ContentEntityObject)this.pageMan.getAbstractPage(toPageId.longValue()));
        return true;
    }

    public void moveBox(Long pageId, String labelsToAdd, Long uploadToPage, String uriList) {
        this.transactionTemplate.execute(() -> this.moveBoxInTransaction(pageId, labelsToAdd, uploadToPage, uriList));
    }

    private boolean moveBoxInTransaction(Long pageId, String labelsToAddList, Long uploadToPage, String url) {
        Attachment attachment;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (this.permissionMan.hasPermission((User)user, Permission.EDIT, (Object)this.pageMan.getAbstractPage(pageId.longValue())) && this.permissionMan.hasPermission((User)user, Permission.EDIT, (Object)this.pageMan.getAbstractPage(uploadToPage.longValue())) && (attachment = (Attachment)this.attachmentMan.findAttachmentForDownloadPath(url).get()) != null) {
            String[] labelsToAdd;
            this.labelMan.removeAllLabels((Labelable)attachment);
            for (String labelToAdd : labelsToAdd = labelsToAddList.split(" *, *")) {
                if (labelToAdd.isEmpty()) continue;
                log.debug("Adding label {} to attachment with id {}", (Object)labelToAdd, (Object)attachment.getId());
                this.labelMan.addLabel((Labelable)attachment, new Label(labelToAdd));
            }
            if (pageId != uploadToPage) {
                log.debug("Moving attachment {} to page {}", (Object)attachment.getId(), (Object)uploadToPage);
                this.attachmentMan.moveAttachment(attachment, attachment.getFileName(), (ContentEntityObject)this.pageMan.getAbstractPage(uploadToPage.longValue()));
            }
            return true;
        }
        return false;
    }

    public boolean isLicensed() {
        return this.licenseMan.getLicense().isDefined() ? ((PluginLicense)this.licenseMan.getLicense().get()).isValid() : false;
    }
}

