if (!window.MOEWE_FontIcons) {
    window.MOEWE_FontIcons = {};
}

window.MOEWE_FontIcons.Selector_From_Soy = function (inputField, settings) {
    let searchContainer = document.createElement("div");
    searchContainer.innerHTML = MOEWE.Templates.sdk.fontIcons.renderSelector({
        fonts: settings.fonts
    });
    searchContainer = searchContainer.firstChild;
    inputField.parentNode.appendChild(searchContainer);
    window.MOEWE_FontIcons.Selector(searchContainer, inputField);
    return searchContainer;
};

window.MOEWE_FontIcons.Selector = function (searchContainer, targetInputField) {
    let searchField = searchContainer.querySelector('[name="font-icon-search"]');
    let fontsField = searchContainer.querySelector('[name="fonts"]');
    let iconGrid = searchContainer.querySelector('.font-search-icon-grid');

    targetInputField.style.display = 'none';

    fontsField.addEventListener('change', selectedFontsChanged);
    searchField.addEventListener('keyup', invokeSearch);
    searchField.addEventListener('change', invokeSearch);

    fontsField.dispatchEvent(new Event('change'));
    searchField.dispatchEvent(new Event('keyup'));

    if (targetInputField.value !== '') {
        let selectedIcon = iconGrid.querySelector('[data-icon="' + targetInputField.value + '"]');
        if (selectedIcon) {
            selectedIcon.dispatchEvent(new Event('click'));
        }
    }

    function selectedFontsChanged(event) {
        iconGrid.innerHTML = '';
        event.target.value.split(",").forEach(font => {
            let library = window.MOEWE_FontIcons.fonts[font];
            if (!library) {
                return;
            }

            for (let iconCode in library.icons) {
                let icon = library.icons[iconCode];
                let iconElement = document.createElement("div");
                iconElement.title = icon.label;
                iconElement.dataset.icon = iconCode;
                iconElement.dataset.font = font;
                iconElement.dataset.search = (iconCode + ' ' + icon.terms.join(' ')).toLowerCase();
                iconElement.innerHTML = library.template.replace(/%iconCode%/g, iconCode);
                iconElement.innerHTML = iconElement.innerHTML.replace(/%label%/g, icon.label);
                iconElement.addEventListener("click", iconSelected);
                iconGrid.appendChild(iconElement);
            }
        });
    }

    function invokeSearch(event) {
        let query = event.target.value;
        if (query.trim() === '') {
            iconGrid.querySelectorAll('div').forEach(element => element.classList.remove('hidden'));
            return;
        }

        query = query.toLowerCase();
        iconGrid.querySelectorAll('[data-search*="' + query + '"]').forEach(element => element.classList.remove('hidden'));
        iconGrid.querySelectorAll('[data-search]:not([data-search*="' + query + '"])').forEach(element => element.classList.add('hidden'));
    }

    function iconSelected(event) {
        iconGrid.querySelectorAll('.selected').forEach(element => element.classList.remove('selected'));
        let div = event.target.closest('[data-icon]');
        div.classList.add('selected');
        targetInputField.value = div.dataset.icon;
        searchContainer.querySelector('.selected-icon').innerHTML = div.innerHTML;
    }
};
