MOEWE.SDK.Components.EntityManagement = function (settings) {

    this._settings = settings;
    this._settings.actions = this._settings.actions || ["ADD", "EDIT", "DELETE"];

    let self = this;
    let fieldControllerPath = this._settings.fieldControllerPath;
    let restPath = this._settings.restPath;
    let formControllerUrl = AJS.Meta.get("base-url") + "/rest" + restPath + "/1.0" + fieldControllerPath;
    let container = document.getElementById(this._settings.containerId);
    let dialogIdPrefix = MOEWE.SDK.Utils.Uuid();
    container.innerHTML = MOEWE.SDK.Components.EntityManagementSoy.content({
        dialogIdPrefix: dialogIdPrefix,
        text: this._settings.text,
        canAdd: this._settings.actions.indexOf('ADD') !== -1,
        canSearch: this._settings.actions.indexOf('SEARCH') !== -1,
        canSearchLabel: this._settings.canSearchLabel || AJS.I18n.getText("moewe-sdk.components.entity-management.search"),
    });

    if (this._settings.itemViewHeader) {
        container.getElementsByClassName("entitymanagement-header")[0].innerHTML = this._settings.itemViewHeader;
    }

    if (this._settings.itemViewFooter) {
        container.getElementsByClassName("entitymanagement-footer")[0].innerHTML = this._settings.itemViewFooter;
    }

    this._settings.itemViewSettings.url = this._settings.itemViewSettings.url || formControllerUrl;
    this._settings.itemViewSettings.resultsContainer = this._settings.itemViewSettings.resultsContainer || container.getElementsByClassName("entitymanagement-body")[0];

    this._itemsView = new MOEWE.SDK.Utils.ItemsView(this._settings.itemViewSettings);

    let currentFormId = null;

    // MOEWE SDK AUI Form Event Listeners
    document.addEventListener("moewe-sdk-auiform:afterRender", afterRender);
    document.addEventListener("moewe-sdk-auiform:afterSaveForm", afterSaveForm);
    document.addEventListener("moewe-sdk:afterItemsViewRender", afterItemsViewRender);

    // Dialog Event Listeners
    // TODO Use plain JS as much as possible
    let dialog = AJS.$(document);

    if (this._settings.actions.indexOf('ADD') !== -1 || this._settings.actions.indexOf('EDIT') !== -1) {
        dialog.on('click', "#" + dialogIdPrefix + "-dialog .moewe-submit-button", {itemsView: this._itemsView}, submit_dialog);
        dialog.on('click', "#" + dialogIdPrefix + "-dialog .moewe-close-button", {itemsView: this._itemsView}, close_dialog);
    }

    if (this._settings.actions.indexOf('ADD') !== -1) {
        dialog.on('click', "#" + this._settings.containerId + " .add-dialog-trigger", {itemsView: this._itemsView}, add_entity);
    }
    if (this._settings.actions.indexOf('EDIT') !== -1) {
        dialog.on('click', "#" + this._settings.containerId + " .edit-dialog-trigger", {itemsView: this._itemsView}, edit_entity);
    }
    if (this._settings.actions.indexOf('DELETE') !== -1) {
        dialog.on('click', "#" + this._settings.containerId + " .delete-dialog-trigger", {itemsView: this._itemsView}, delete_entity);
        dialog.on('click', "#" + dialogIdPrefix + "-delete-dialog .moewe-submit-button", {itemsView: this._itemsView}, submit_delete_dialog);
        dialog.on('click', "#" + dialogIdPrefix + "-delete-dialog .moewe-close-button", {itemsView: this._itemsView}, close_dialog);
    }


    function afterRender(event) {
        if (event.detail.domElement.classList.contains("aui-dialog2-content")) {
            currentFormId = event.detail.settings.form.id;
            // hide button container in dialog
            event.detail.domElement.querySelectorAll(".buttons-container").forEach(buttonContainer => {
                buttonContainer.style.display = 'none';
            });
        }
    }

    function afterSaveForm(event) {
        if (event.detail.settings.form.id === currentFormId) {
            self._itemsView.reload();
            AJS.dialog2("#" + dialogIdPrefix + "-dialog").hide();
        }
    }

    function afterItemsViewRender(event) {

        let detail = event.detail;
        if (detail.response.type !== undefined && detail.response.type === "PageableResponse") {
            let total = detail.response.total;
            let offset = detail.response.offset;
            let limit = detail.response.limit;

            let pagingHTML = MOEWE.Templates.SDK.Commons.renderPaging({
                paging: {
                    offset: offset,
                    limit: limit,
                    current: 1 + (offset > 0 ? offset / limit : 0),
                    prev: offset - limit,
                    next: offset + limit,
                    last: (total % limit) === 0 ? (total - limit) : total - (total % limit),
                    isFirst: offset === 0,
                    isLast: offset + limit >= total,
                }
            });

            let table = detail.itemsView._settings.resultsContainer.closest("table");
            let container = table.parentElement;
            let pagingElements = container.getElementsByClassName("moewe-sdk-paging")

            while (pagingElements.length > 0) {
                pagingElements[0].parentNode.removeChild(pagingElements[0]);
            }

            container.insertBefore(MOEWE.SDK.Utils.createElementFromHTML(pagingHTML), table);
            container.insertBefore(MOEWE.SDK.Utils.createElementFromHTML(pagingHTML), table.nextSibling);
            container.querySelectorAll("[data-paging-offset]").forEach(pageOffsetLink => {
                pageOffsetLink.addEventListener("click", function () {
                    detail.itemsView._settings.params.offset = pageOffsetLink.dataset.pagingOffset;
                    detail.itemsView.reload();
                });
            });
            container.querySelectorAll("[name='entity-management-search']").forEach(searchInput =>
                searchInput.addEventListener('input', event => {
                    let value = searchInput.value;
                    value = value.trim();
                    value = value === "*" ? "" : value;
                    detail.itemsView._settings.params.offset = 0;
                    detail.itemsView._settings.params.search = value;
                    detail.itemsView.reload();
                })
            )
        }

        document.dispatchEvent(new CustomEvent('moewe-sdk:afterEntityManagementRender', {
            detail: {
                request: event.detail.request,
                response: event.detail.response,
                entityManagement: self,
            }
        }));
    }

    function add_entity(event) {
        event.preventDefault();
        let dialog = document.getElementById(dialogIdPrefix + "-dialog");
        dialog.getElementsByClassName("aui-dialog2-header-main")[0].innerHTML = AJS.I18n.getText("moewe-sdk.components.entity-management.add") + ' ' + self._settings.text.entityName;
        let container = dialog.getElementsByClassName("aui-dialog2-content")[0];
        container.innerHTML = '';
        moewe_aui_load_form(container, fieldControllerPath, restPath, "");
        AJS.dialog2("#" + dialogIdPrefix + "-dialog").show();
    }

    function edit_entity(event) {
        event.preventDefault();
        let dialog = document.getElementById(dialogIdPrefix + "-dialog");
        dialog.getElementsByClassName("aui-dialog2-header-main")[0].innerHTML = AJS.I18n.getText("moewe-sdk.components.entity-management.edit") + ' ' + self._settings.text.entityName;
        let container = dialog.getElementsByClassName("aui-dialog2-content")[0];
        container.innerHTML = '';
        moewe_aui_load_form(container, fieldControllerPath, restPath, AJS.$(this).data("entityId"));
        event.data.itemsView.reload()
        AJS.dialog2("#" + dialogIdPrefix + "-dialog").show();
    }

    function delete_entity(event) {
        event.preventDefault();
        AJS.$("#" + dialogIdPrefix + "-delete-dialog .moewe-submit-button").data("entityId", AJS.$(this).data("entityId"));
        AJS.dialog2("#" + dialogIdPrefix + "-delete-dialog").show();
    }

    function submit_dialog(event) {
        event.preventDefault();
        if (currentFormId != null) {
            document.getElementById(currentFormId).getElementsByClassName("buttons-container")[0].getElementsByClassName("aui-button-primary")[0].click()
        }
        return false;
    }

    function submit_delete_dialog(event) {
        event.preventDefault();
        let itemView = event.data.itemsView;
        new MOEWE.SDK.Utils.Ajax({
            url: formControllerUrl + '/' + AJS.$(this).data("entityId"),
            method: "DELETE",
            callback: {
                success: function (request, response, settings) {
                    itemView.reload();
                }
            }
        });

        let dialogId = AJS.$(this).closest(".aui-dialog2").attr("id");
        AJS.dialog2("#" + dialogId).hide();
    }

    function close_dialog(event) {
        event.preventDefault();
        event.data.itemsView.reload();
        let dialogId = AJS.$(this).closest(".aui-dialog2").attr("id");
        AJS.dialog2("#" + dialogId).hide();
    }
};

MOEWE.SDK.Components.EntityManagement.prototype.reload = function () {
    this._itemsView.reload();
};
