MOEWE = typeof (MOEWE) !== 'undefined' ? MOEWE : {};

MOEWE.inherit = function (base, sub) {
    // Avoid instantiating the base class just to setup inheritance
    // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/create
    // for a polyfill
    // Also, do a recursive merge of two prototypes, so we don't overwrite
    // the existing prototype, but still maintain the inheritance chain
    // Thanks to @ccnokes
    var origProto = sub.prototype;
    sub.prototype = Object.create(base.prototype);
    for (var key in origProto) {
        sub.prototype[key] = origProto[key];
    }
    // Remember the constructor property was set wrong, let's fix it
    sub.prototype.constructor = sub;
    // In ECMAScript5+ (all modern browsers), you can make the constructor property
    // non-enumerable if you define it like this instead
    Object.defineProperty(sub.prototype, 'constructor', {
        enumerable: false,
        value: sub
    });
};

MOEWE.Addons = MOEWE.Addons || {};

MOEWE.SDK = MOEWE.SDK || {};

MOEWE.SDK.Components = MOEWE.SDK.Components || {};

MOEWE.SDK.Utils = MOEWE.SDK.Utils || {};

MOEWE.SDK.Utils.Uuid = function () {
    let dt = new Date().getTime();
    let uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        let r = (dt + Math.random() * 16) % 16 | 0;
        dt = Math.floor(dt / 16);
        return (c === 'x' ? r : (r & 0x3 | 0x8)).toString(16);
    });
    return uuid;
}

MOEWE.SDK.Utils.EncodeParams = function (obj) {
    let str = [];
    for (let p in obj)
        if (obj.hasOwnProperty(p)) {
            str.push(encodeURIComponent(p) + "=" + encodeURIComponent(obj[p]));
        }
    return str.join("&");
}

MOEWE.SDK.Utils.createElementFromHTML = function (html) {
    let div = document.createElement('div');
    div.innerHTML = html.trim();
    return div.firstChild;
}

MOEWE.SDK.Utils.Ajax = function (settings) {
    this._settings = settings;

    if (typeof this._settings.method === 'undefined') {
        this._settings.method = 'GET'
    }

    if (typeof this._settings.content_type === 'undefined') {
        this._settings.content_type = "application/json";
    }

    if (typeof this._settings.params === 'undefined') {
        this._settings.params = {};
    }

    if (typeof this._settings.params.atl_token === 'undefined') {
        this._settings.params.atl_token = document.getElementsByName("atlassian-token")[0].content;
    }

    if (typeof this._settings.callback === 'undefined') {
        this._settings.callback = {}
    }

    if (typeof this._settings.callback.success === 'undefined') {
        this._settings.callback.success = function (request, response, settings) {
        };
    }

    if (typeof this._settings.callback.error === 'undefined') {
        this._settings.callback.error = function (request) {
        };
    }

    this._request = new XMLHttpRequest();
    this._request.moewe = {
        self: this
    }

    this._request.addEventListener('load', this.process_response);

    this._request_url = this._settings.url + "?" + MOEWE.SDK.Utils.EncodeParams(this._settings.params);
    this._request.open(this._settings.method, this._request_url);
    this._request.setRequestHeader("Content-Type", this._settings.content_type);

    if (typeof this._settings.body === 'undefined') {
        this._request.send();
    } else {
        this._request.send(this._settings.body);
    }
}

MOEWE.SDK.Utils.Ajax.prototype.reload = function (params) {
    let tempSettings = this._settings.params;
    if (params) {
        this._settings.params = {tempSettings, params};
    }
    this._request.open(this._settings.method, this._settings.url + "?" + MOEWE.SDK.Utils.EncodeParams(this._settings.params));
    this._request.send();
};

MOEWE.SDK.Utils.Ajax.prototype.process_response = function (event) {
    var self = this.moewe.self;
    var settings = self._settings;
    if (this.status >= 200 && this.status < 300) {
        let response = this.responseText;
        if (response != "" && settings.content_type == "application/json") {
            response = JSON.parse(response);
        }
        settings.callback.success(this, response, settings);
    } else {
        settings.callback.error(this);
    }
};

MOEWE.SDK.Utils.ItemsView = function (settings) {
    this._settings = settings;

    if (typeof this._settings.callback === 'undefined') {
        this._settings.callback = {}
    }

    if (typeof this._settings.callback.renderItem === 'undefined') {
        this._settings.callback.renderItem = function (result) {
        };
    }

    this._settings.callback.getResponseResults = this._settings.callback.getResponseResults || function (response) {
        return response; // as default response returns
    }

    if (typeof this._settings.text === 'undefined') {
        this._settings.text = {};
    }

    if (typeof this._settings.text.noResults === 'undefined') {
        this._settings.text.noResults = "";
    }

    let self = this;
    this._ajaxSettings = {
        url: this._settings.url,
        params: this._settings.params,
        callback: {
            success: function (request, response, settings) {
                var html = ''
                let results = self._settings.callback.getResponseResults(response);
                if (results.length > 0) {
                    results.forEach(result =>
                        html += self._settings.callback.renderItem(result)
                    );
                } else {
                    html += self._settings.text.noResults;
                }
                self._settings.resultsContainer.innerHTML = html;

                document.dispatchEvent(new CustomEvent('moewe-sdk:afterItemsViewRender', {
                    detail: {
                        request: request,
                        response: response,
                        itemsView: self,
                    }
                }));
            }
        }
    }

    this._settings.resultsContainer.innerHTML = '<aui-spinner size="medium"></aui-spinner>';

    this._ajax = new MOEWE.SDK.Utils.Ajax(this._ajaxSettings);
}

MOEWE.SDK.Utils.ItemsView.prototype.reload = function (params) {
    this._ajax.reload(params);
};
