AJS.toInit(function ($) {

    addUserHoverLinkActions();

    function addUserHoverLinkActions() {
        jQuery(".give-medal-dialog:not(.medaldialogized)").click(function (event) {
            let username = jQuery(this).closest(".ajs-content-hover").find(".confluence-userlink").attr("data-username");
            jQuery(this).attr("data-preselected-user", username);
            openMedalDialog(event, jQuery(this));
        }).addClass("medaldialogized");
        setTimeout(addUserHoverLinkActions, 1000);
    }

    function openMedalDialog(event, link) {
        event.preventDefault();
        let preselectedUser = link.data('preselectedUser');
        let linkText = link.text();

        let dialog = new AJS.Dialog({
            width: 600,
            height: 600,
            id: "give-medal-dialog",
            closeOnOutsideClick: true
        });

        dialog.addHeader(linkText, "karma-dialog");
        dialog.addButton(linkText, giveMedal, "medal-save-button");
        dialog.addCancel(AJS.I18n.getText("communardo.karma.user.medal.close"), function () {
            dialog.remove()
        });

        let karmaUsername = document.querySelector('#karmausername')?.value

        jQuery.post(contextPath + "/plugins/servlet/karma/medal/loadmedalview?username=" + karmaUsername, function (result) {
            let panel = jQuery(result);
            dialog.addPanel(linkText, panel, "karma-dialog-panel", 1);
            initDialog(panel);
        });

        dialog.show();

        function initDialog(dialogPanel) {
            manageSendButton();

            dialogPanel.find(".medal").click(function () {
                dialogPanel.find(".medal").removeClass("selected");
                jQuery(this).addClass("selected");
                dialogPanel.find(".hidden-input-achievement-uuid").val(jQuery(this).data("achievementUuid"));
                manageSendButton();
            });

            let medalCommentField = dialogPanel.find('[name="medalcomment"]');

            medalCommentField.keyup(function () {
                limitText(jQuery(this), dialogPanel.find(".commentlimit"), 160)
            });

            limitText(medalCommentField, dialogPanel.find(".commentlimit"), 160)


            function limitText(limitField, limitCount, limitNum) {
                if (limitField.val().length > limitNum) {
                    limitField.val(limitField.val().substring(0, limitNum));
                }
                limitCount.html(limitNum - limitField.val().length);
            }

            if (AJS.Confluence.Binder.autocompleteUserOrGroup) {
                AJS.Confluence.Binder.autocompleteUserOrGroup(dialogPanel);
            } else if (AJS.Confluence.Binder.autocompleteUser) {
                AJS.Confluence.Binder.autocompleteUser(dialogPanel);
            }

            dialogPanel.find(".medal-receiver-form, .medal-message-form").submit(function () {
                if (dialogPanel.find(".autocomplete-user").val().length > 0) {
                    addContact(dialogPanel);
                }
                return false;
            });

            function addContact(dialogPanel) {

                var recieverInput = dialogPanel.find(".autocomplete-user");
                dialogPanel.find(".hidden-input-medal-reciever").val(recieverInput.val());

                jQuery.post(contextPath + "/plugins/servlet/karma/medal/loadmedalreciever?" + dialogPanel.find(".medal-receiver-form").serialize(), function (result) {
                    dialogPanel.find(".medal-receiver-container").html(jQuery(result));

                    if (jQuery(result).find("img")) {
                        dialogPanel.find(".hidden-input-medal-reciever").val(recieverInput.val());
                        manageSendButton();
                    }
                });
            }

            dialogPanel.find(".autocomplete-user").click().focus().bind("selected.autocomplete-user", function (e, data) {
                addContact(dialogPanel);
            });

            if (preselectedUser && preselectedUser !== '' && preselectedUser !== AJS.Meta.get("remote-user")) {
                dialogPanel.find(".autocomplete-user").val(preselectedUser);
                dialogPanel.find(".medal-receiver-form").submit();
            }
        }

        function manageSendButton() {
            if (jQuery("#give-medal-dialog .hidden-input-achievement-uuid").val() &&
                jQuery("#give-medal-dialog .hidden-input-medal-reciever").val()) {
                jQuery("#give-medal-dialog .medal-save-button").removeAttr("aria-disabled", "true").removeAttr("disabled");
            } else {
                jQuery("#give-medal-dialog .medal-save-button").attr("aria-disabled", "true").attr("disabled", "disabled");
            }
        }

        function giveMedal() {
            jQuery("#give-medal-dialog .medal-save-button").attr("aria-disabled", "true").attr("disabled", "disabled");
            jQuery.post(contextPath + "/plugins/servlet/karma/medal/givemedal?" + jQuery("#give-medal-dialog .medal-message-form").serialize(), function (result) {
                var dialogPanel = jQuery("#give-medal-dialog .karma-dialog-panel");
                dialogPanel.html(jQuery(result));
                initDialog(dialogPanel);
                jQuery("#give-medal-dialog .medal-save-button").removeAttr("aria-disabled", "true").removeAttr("disabled");
            });
        }
    }
});
