var KarmaUser = function () {

    this.init = function () {
        attachKarmaToCurrentLoggedInUser();
        attachKarmaToUserLinks();
    };

    var karmaCache = {};

    function attachKarmaToUserLinks() {

        var userList = [];
        var userElementMap = {};
        jQuery('body a[data-username]:not(.karmatized)').addClass("karmatized").each(function () {
            var linkObject = jQuery(this);
            var username = linkObject.attr("data-username");

            if (username != undefined && username != "") {
                username = decodeURIComponent(username);
                username = username.replace("+", " ");
                if (karmaCache[username]) {
                    modifyUserLink(jQuery(this), karmaCache[username]);
                } else {
                    if (jQuery.inArray(username, userList) == -1) {
                        userList.push(username);
                    }

                    if (!userElementMap[username]) {
                        userElementMap[username] = [];
                    }
                    userElementMap[username].push(jQuery(this));
                }
            }
        });


        if (userList.length > 0) {
            jQuery.get(contextPath + "/rest/moewe-awards/1.0/user/profiles?usernames=" + userList.join(","), function (data) {
                jQuery.each(data, function (index, userEntry) {
                    if (userElementMap[userEntry.username]) {
                        for (var i = 0; i < userElementMap[userEntry.username].length; i++) {
                            modifyUserLink(userElementMap[userEntry.username][i], userEntry);
                        }
                        karmaCache[userEntry.username] = data[userEntry.username];
                    }
                });
            });
        }

        setTimeout(attachKarmaToUserLinks, 1000);
    }

    function awards_format_points(points, unit) {
        if (typeof unit !== 'undefined' && unit != "") {
            return points + " " + unit;
        }
        return points;
    }

    function modifyUserLink(linkObject, userEntry) {

        if (!linkObject.hasClass("nokarmauserlink")) {

            var elementToLookFor = linkObject.find("*:contains('" + userEntry.fullName + "')");

            if (jQuery(linkObject).clone().children().remove().end().text().indexOf(userEntry.fullName) > -1) {

                linkObject.html(linkObject.html() + " (" + awards_format_points(userEntry.totalPoints, userEntry.unit) + ")");

            } else if (elementToLookFor && elementToLookFor.length > 0) {
                elementToLookFor.last().html(elementToLookFor.last().html() + " (" + awards_format_points(userEntry.totalPoints, userEntry.unit) + ")");
            }

            var movingBadges = getSortedKarmaLeaderBadges(userEntry.badges);

            if ((linkObject.hasClass("userLogoLink") || linkObject.hasClass("confluence-userlink")) && linkObject.children("img.userLogo").length > 0 && movingBadges.length > 0) {
                var closestHover = linkObject.closest(".ajs-content-hover");
                var lastMovingBadge = movingBadges[0];
                if (closestHover.length > 0) {
                    if (!closestHover.hasClass("karmatized")) {
                        closestHover.prepend('<div class="karmaprofilehoverbadgetitle ' + lastMovingBadge.key + '" >' + lastMovingBadge.title + '</div>');
                        closestHover.addClass("karmatized");
                    }
                }

                if (closestHover.length == 0) {
                    linkObject.prepend('<img class="badge ' + lastMovingBadge.key + '" src="' + contextPath + '/download/resources/de.communardo.confluence.plugins.karma:karma-overview-ressources/images/frame-' + lastMovingBadge.key + '.png" />');
                }
            }
        }
    }

    function attachKarmaToCurrentLoggedInUser() {
        let username = document.querySelector('meta[name=ajs-remote-user]').content;
        var linkObject = jQuery("#user-menu-link span span");
        jQuery.get(contextPath + "/rest/moewe-awards/1.0/user/" + username + "/profile", function (data) {
            if (data != null && data.totalPoints) {
                linkObject.html(linkObject.html() + " (" + awards_format_points(data.totalPoints, data.unit) + ")");
                linkObject.addClass("karmatized");
                //pimp the title
                if (jQuery("#user-menu-link").attr("title")) {
                    jQuery("#user-menu-link").attr("title", jQuery("#user-menu-link").attr("title") + " (" + awards_format_points(data.totalPoints, data.unit) + ")");
                }
            }
        });
    }

    /**
     *   Only return the karma Leader Badges sorted by its worth.
     */
    function getSortedKarmaLeaderBadges(badges) {
        var ranking = {
            "badge-karmaleader-DAY": 5,
            "badge-karmaleader-WEEK": 4,
            "badge-karmaleader-MONTH": 3,
            "badge-karmaleader-YEAR": 2,
            "badge-karmaleader-OVERALL": 1,
        };
        var movingBadges = [];
        jQuery.each(badges, function (index, badge) {
            if (badge.type === "MOVING") {
                movingBadges.push(badge);
            }
        });

        if (movingBadges.length > 1) {
            movingBadges.sort(function (badgeA, badgeB) {
                if (ranking[badgeA.key] > ranking[badgeB.key]) {
                    return 1
                }
                if (ranking[badgeA.key] < ranking[badgeB.key]) {
                    return -1
                }
                return 0;
            });
        }
        return movingBadges;
    }
};


jQuery(function () {
    new KarmaUser().init();
});
