/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.hibernate.validator.ap.internal.checks.ConstraintCheck;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.checks.ConstraintChecks;
import org.hibernate.validator.ap.internal.util.CollectionHelper;

public class SingleValuedChecks
implements ConstraintChecks {
    private final List<ConstraintCheck> checks;

    public SingleValuedChecks(ConstraintCheck ... checks) {
        this.checks = checks == null ? Collections.emptyList() : Arrays.asList(checks);
    }

    @Override
    public Set<ConstraintCheckIssue> execute(Element element, AnnotationMirror annotation) {
        HashSet<ConstraintCheckIssue> theValue = CollectionHelper.newHashSet();
        for (ConstraintCheck oneCheck : this.checks) {
            if (element.getKind() == ElementKind.PARAMETER) {
                theValue.addAll(oneCheck.checkField((VariableElement)element, annotation));
            } else if (element.getKind() == ElementKind.FIELD) {
                theValue.addAll(oneCheck.checkField((VariableElement)element, annotation));
            } else if (element.getKind() == ElementKind.METHOD) {
                theValue.addAll(oneCheck.checkMethod((ExecutableElement)element, annotation));
            } else if (element.getKind() == ElementKind.ANNOTATION_TYPE) {
                theValue.addAll(oneCheck.checkAnnotationType((TypeElement)element, annotation));
            } else if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ENUM) {
                theValue.addAll(oneCheck.checkNonAnnotationType((TypeElement)element, annotation));
            }
            if (theValue.isEmpty()) continue;
            return theValue;
        }
        return theValue;
    }
}

