/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.servlet;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import io.moewe.atlassian.sdk.auiforms.FormService;
import io.moewe.atlassian.sdk.internal.license.MoeweLicenseService;
import io.moewe.confluence.addons.awards.AchievementType;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.services.AchievementService;
import io.moewe.confluence.addons.awards.services.BadgeManager;
import io.moewe.confluence.addons.awards.services.KarmaEventManager;
import io.moewe.confluence.addons.awards.services.KarmaHistoryManager;
import io.moewe.confluence.addons.awards.services.KarmaPropertyManager;
import io.moewe.confluence.addons.awards.services.KarmaScoreManager;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import io.moewe.confluence.addons.awards.services.MedalManager;
import io.moewe.confluence.addons.awards.services.UserAwardsService;
import io.moewe.confluence.addons.awards.servlet.AwardsServlet;
import io.moewe.confluence.addons.awards.util.AwardsApplicationManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MedalServlet
extends AwardsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwardsServlet.class);
    private static final long serialVersionUID = 8869539604555456211L;
    private final AwardsApplicationManager karmaApplicationService;
    private final AchievementService achievementService;

    public MedalServlet(@ComponentImport TemplateRenderer templateRenderer, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport I18nResolver i18nResolver, KarmaEventManager karmaEventManager, @ComponentImport UserManager userManager, BadgeManager badgeManager, MedalManager medalManager, KarmaUserManager karmaUserManager, KarmaPropertyManager karmaPropertyManager, KarmaHistoryManager karmaHistoryManager, KarmaScoreManager karmaScoreManager, @ComponentImport PluginAccessor pluginAccessor, UserAwardsService userAwardsService, MoeweLicenseService licenseService, FormService formService, AwardsApplicationManager karmaApplicationService, AchievementService achievementService) {
        super(templateRenderer, pageBuilderService, i18nResolver, karmaEventManager, userManager, badgeManager, medalManager, karmaUserManager, karmaPropertyManager, karmaHistoryManager, karmaScoreManager, pluginAccessor, userAwardsService, licenseService, formService);
        this.karmaApplicationService = karmaApplicationService;
        this.achievementService = achievementService;
    }

    public void loadmedalview(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.loadmedalview(request, response, null);
    }

    public void loadmedalreciever(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String remoteUsername = this.userManager.getRemoteUser().getUsername();
        String reciever = request.getParameter("reciever");
        if (remoteUsername != null && reciever != null) {
            HashMap<String, Object> velocityContext = new HashMap<String, Object>();
            UserProfile userProfile = this.userManager.getUserProfile(reciever);
            KarmaUserProfile recieverKarmaUserProfile = this.karmaUserManager.getKarmaUserFromUsername(reciever);
            String profilePictureUri = this.karmaApplicationService.getContextPath() + this.karmaApplicationService.getStandardProfilePictureUrl();
            if (userProfile != null && recieverKarmaUserProfile != null) {
                if (!this.karmaUserManager.isKarmaParticipant(recieverKarmaUserProfile)) {
                    velocityContext.put("error", this.i18nResolver.getText("communardo.karma.message.otheruser.no.participant.description"));
                } else if (reciever.equals(remoteUsername)) {
                    velocityContext.put("error", this.i18nResolver.getText("communardo.karma.medal.send.error.message.selfmedal"));
                }
                if (userProfile.getProfilePictureUri() != null) {
                    profilePictureUri = this.karmaApplicationService.getContextPath() + userProfile.getProfilePictureUri().toString();
                }
            }
            velocityContext.put("recieverurl", profilePictureUri);
            this.renderVelocity(request, response, "vm/medalreciever.vm", velocityContext);
        } else {
            response.sendError(401);
        }
    }

    public void givemedal(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String remoteUsername = this.userManager.getRemoteUser().getUsername();
        String reciever = request.getParameter("reciever");
        String medalcomment = request.getParameter("medalcomment");
        if (this.i18nResolver.getText("communardo.karma.user.medal.description.placeholder").equals(medalcomment)) {
            medalcomment = "";
        }
        String achievementUuid = request.getParameter("achievementUuid");
        KarmaUserProfile remoteUsernameKarmaUserProfile = this.karmaUserManager.getKarmaUserFromUsername(remoteUsername);
        KarmaUserProfile recieverKarmaUserProfile = this.karmaUserManager.getKarmaUserFromUsername(reciever);
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        if (remoteUsernameKarmaUserProfile == null || recieverKarmaUserProfile == null || achievementUuid == null) {
            LOGGER.error(String.format("Error during medal rewarding, some things are undefined remoteUsernameKarmaUserProfile: %s, recieverKarmaUserProfile: %s, achievementUuid: %s", remoteUsernameKarmaUserProfile, recieverKarmaUserProfile, achievementUuid));
            velocityContext.put("error", this.i18nResolver.getText("communardo.karma.medal.send.error.message"));
        } else if (!this.karmaUserManager.isKarmaParticipant(recieverKarmaUserProfile)) {
            velocityContext.put("error", this.i18nResolver.getText("communardo.karma.message.otheruser.no.participant.description"));
        } else if (remoteUsername.equals(reciever)) {
            velocityContext.put("error", this.i18nResolver.getText("communardo.karma.medal.send.error.message.selfmedal"));
        } else if (this.medalManager.giveMedal(achievementUuid, remoteUsernameKarmaUserProfile, recieverKarmaUserProfile, medalcomment)) {
            velocityContext.put("success", this.i18nResolver.getText("communardo.karma.medal.send.success.message") + " " + this.i18nResolver.getText("communardo.karma.global.administration.medalsperday.left", new Serializable[]{Integer.valueOf(this.medalManager.getRemainingMedals(remoteUsernameKarmaUserProfile))}));
        } else if (this.medalManager.getRemainingMedals(remoteUsernameKarmaUserProfile) <= 0) {
            velocityContext.put("error", this.i18nResolver.getText("communardo.karma.global.administration.error.invalid.medalsperday"));
        } else {
            LOGGER.error("Other errors occured during medal rewarding");
            velocityContext.put("error", this.i18nResolver.getText("communardo.karma.medal.send.error.message"));
        }
        this.loadmedalview(request, response, velocityContext);
    }

    private void loadmedalview(HttpServletRequest request, HttpServletResponse response, Map<String, Object> outercontext) throws IOException {
        String remoteUsername = this.userManager.getRemoteUser().getUsername();
        if (remoteUsername != null) {
            HashMap<String, Object> velocityContext = outercontext != null ? outercontext : new HashMap<String, Object>();
            velocityContext.put("karmaManager", this.karmaEventManager);
            velocityContext.put("medalManager", this.medalManager);
            velocityContext.put("medalAchievements", this.achievementService.getActiveAchievements(AchievementType.MEDAL));
            velocityContext.put("userAwardsService", this.userAwardsService);
            this.renderVelocity(request, response, "vm/medalview.vm", velocityContext);
        } else {
            response.sendError(401);
        }
    }
}

