/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.servlet;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.moewe.confluence.addons.awards.ao.BadgeEntry;
import io.moewe.confluence.addons.awards.ao.KarmaEntry;
import io.moewe.confluence.addons.awards.ao.MedalDao;
import io.moewe.confluence.addons.awards.services.BadgeManager;
import io.moewe.confluence.addons.awards.services.KarmaEventManager;
import io.moewe.confluence.addons.awards.services.MedalManager;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportServlet.class);
    private final String SEPERATOR = ",";
    private static final String I18N_TABLE_HEAD_PREFIX = "io.moewe.confluence.addons.awards.administration.export.table.head.";
    private static final String QUOTE = "\"";
    private final UserManager userManager;
    private final KarmaEventManager karmaEventManager;
    private final MedalManager medalManager;
    private final BadgeManager badgeManager;
    private final I18nResolver i18nResolver;
    private final LoginUriProvider loginUriProvider;

    public ExportServlet(UserManager userManager, KarmaEventManager karmaEventManager, MedalManager medalManager, BadgeManager badgeManager, I18nResolver i18nResolver, @ComponentImport LoginUriProvider loginUriProvider) {
        this.userManager = userManager;
        this.karmaEventManager = karmaEventManager;
        this.medalManager = medalManager;
        this.badgeManager = badgeManager;
        this.i18nResolver = i18nResolver;
        this.loginUriProvider = loginUriProvider;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UserKey user = this.userManager.getRemoteUserKey();
        if (user == null) {
            this.redirectToLogin(request, response);
            return;
        }
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            response.setContentType("text/csv; charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String startDate = request.getParameter("start");
            Date start = sdf.parse(startDate);
            long millisStart = start.getTime();
            String endDate = request.getParameter("end");
            Date end = sdf.parse(endDate);
            long millisEnd = end.getTime();
            millisEnd += 86400000L;
            String type = request.getParameter("type");
            if (type.equals("points")) {
                outputStream.write(this.generateHeadPoints(",").getBytes());
                response.setHeader("Content-Disposition", "attachment; filename=export-points.csv");
                this.generateBodyPoints(",", (OutputStream)outputStream, 0, 500, millisStart, millisEnd);
            } else if (type.equals("badge")) {
                outputStream.write(this.generateHeadBadge(",").getBytes());
                response.setHeader("Content-Disposition", "attachment; filename=export-badges.csv");
                this.generateBodyBadge(",", (OutputStream)outputStream, 0, 500, millisStart, millisEnd);
            } else {
                outputStream.write(this.generateHeadMedal(",").getBytes());
                response.setHeader("Content-Disposition", "attachment; filename=export-medals.csv");
                this.generateBodyMedal(",", (OutputStream)outputStream, 0, 500, millisStart, millisEnd);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            LOGGER.error("Exception while generating excel export", (Throwable)e);
        }
    }

    private String generateHeadPoints(String seperator) {
        StringBuilder outputResult = new StringBuilder();
        outputResult.append(QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.karma.id")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.karma.contextId")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.karma.description")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.karma.eventKey")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.karma.karma")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.karma.userId")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.karma.creationDate")).append(QUOTE);
        outputResult.append("\n");
        LOGGER.debug(outputResult.toString());
        return outputResult.toString();
    }

    private String generateHeadBadge(String seperator) {
        StringBuilder outputResult = new StringBuilder();
        outputResult.append(QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.badge.id")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.badge.awardTime")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.badge.progress")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.badge.user")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.badge.achievement.uuid")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.badge.achievement.name")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.badge.achievement.description")).append(QUOTE);
        outputResult.append("\n");
        LOGGER.debug(outputResult.toString());
        return outputResult.toString();
    }

    private String generateHeadMedal(String seperator) {
        StringBuilder outputResult = new StringBuilder();
        outputResult.append(QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.medal.id")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.medal.awardTime")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.medal.description")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.medal.receiver")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.medal.sender")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.medal.achievement.uuid")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.medal.achievement.name")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.administration.export.table.head.medal.achievement.description")).append(QUOTE);
        outputResult.append("\n");
        LOGGER.debug(outputResult.toString());
        return outputResult.toString();
    }

    private void generateBodyPoints(String seperator, OutputStream outputStream, int offset, int limit, long millisStart, long millisEnd) throws IOException {
        KarmaEntry[] karmaEntries = this.karmaEventManager.getKarmaEntries(offset, limit, millisStart, millisEnd);
        if (karmaEntries.length > 0) {
            StringBuilder outputResultBuilder = new StringBuilder();
            for (KarmaEntry karmaEntry : karmaEntries) {
                outputResultBuilder.append(QUOTE).append(karmaEntry.getID()).append(QUOTE);
                String contextId = karmaEntry.getContextId();
                if (contextId != null) {
                    outputResultBuilder.append(seperator + QUOTE).append(contextId).append(QUOTE);
                } else {
                    outputResultBuilder.append(seperator + QUOTE).append(QUOTE);
                }
                String description = karmaEntry.getDescription();
                if (description != null) {
                    outputResultBuilder.append(seperator + QUOTE).append(description).append(QUOTE);
                } else {
                    outputResultBuilder.append(seperator + QUOTE).append(QUOTE);
                }
                outputResultBuilder.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.awards.event." + karmaEntry.getEventKey() + ".message")).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(karmaEntry.getKarma()).append(QUOTE);
                String username = "";
                if (karmaEntry.getKarmaUser() != null) {
                    UserKey userKey = new UserKey(karmaEntry.getKarmaUser().getUserKey());
                    UserProfile profile = this.userManager.getUserProfile(userKey);
                    username = profile == null ? "Anonymous" : profile.getUsername();
                }
                outputResultBuilder.append(seperator + QUOTE).append(username).append(QUOTE);
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                long milliSeconds = karmaEntry.getCreationTime();
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(milliSeconds);
                outputResultBuilder.append(seperator + QUOTE).append(formatter.format(calendar.getTime())).append(QUOTE);
                outputResultBuilder.append("\n");
            }
            outputStream.write(outputResultBuilder.toString().getBytes());
            this.generateBodyPoints(seperator, outputStream, offset + limit, limit, millisStart, millisEnd);
        }
    }

    private void generateBodyBadge(String seperator, OutputStream outputStream, int offset, int limit, long millisStart, long millisEnd) throws IOException {
        BadgeEntry[] badgeEntries = this.badgeManager.getBadges(offset, limit, millisStart, millisEnd);
        if (badgeEntries.length > 0) {
            StringBuilder outputResultBuilder = new StringBuilder();
            for (BadgeEntry badgeEntry : badgeEntries) {
                outputResultBuilder.append(QUOTE).append(badgeEntry.getID()).append(QUOTE);
                String time = "";
                if (badgeEntry.getAwardTime() != 0L) {
                    SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                    long milliSeconds = badgeEntry.getAwardTime();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(milliSeconds);
                    time = formatter.format(calendar.getTime());
                }
                outputResultBuilder.append(seperator + QUOTE).append(time).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(badgeEntry.getProgressPercentage()).append(QUOTE);
                String username = "";
                if (badgeEntry.getKarmaUser() != null) {
                    UserKey userKey = new UserKey(badgeEntry.getKarmaUser().getUserKey());
                    UserProfile profile = this.userManager.getUserProfile(userKey);
                    username = profile == null ? "Anonymous" : profile.getUsername();
                }
                outputResultBuilder.append(seperator + QUOTE).append(username).append(QUOTE);
                String achievementUuid = "";
                String achievementName = "";
                String achievementDescription = "";
                if (badgeEntry.getAchievement() != null) {
                    achievementUuid = badgeEntry.getAchievement().getUuid();
                    achievementName = badgeEntry.getAchievement().getName();
                    achievementDescription = badgeEntry.getAchievement().getDescription();
                }
                outputResultBuilder.append(seperator + QUOTE).append(achievementUuid).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(achievementName).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(achievementDescription).append(QUOTE);
                outputResultBuilder.append("\n");
            }
            outputStream.write(outputResultBuilder.toString().getBytes());
            this.generateBodyBadge(seperator, outputStream, offset + limit, limit, millisStart, millisEnd);
        }
    }

    private void generateBodyMedal(String seperator, OutputStream outputStream, int offset, int limit, long millisStart, long millisEnd) throws IOException {
        MedalDao[] medalDaos = this.medalManager.getMedals(offset, limit, millisStart, millisEnd);
        if (medalDaos.length > 0) {
            StringBuilder outputResultBuilder = new StringBuilder();
            for (MedalDao medalDao : medalDaos) {
                outputResultBuilder.append(QUOTE).append(medalDao.getID()).append(QUOTE);
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                long milliSeconds = medalDao.getAwardTime();
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(milliSeconds);
                outputResultBuilder.append(seperator + QUOTE).append(formatter.format(calendar.getTime())).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(medalDao.getDescription()).append(QUOTE);
                UserKey userKey1 = new UserKey(medalDao.getKarmaUser().getUserKey());
                UserProfile profile1 = this.userManager.getUserProfile(userKey1);
                String receiver = profile1 == null ? "Anonymous" : profile1.getUsername();
                outputResultBuilder.append(seperator + QUOTE).append(receiver).append(QUOTE);
                UserKey userKey2 = new UserKey(medalDao.getGivingKarmaUser().getUserKey());
                UserProfile profile2 = this.userManager.getUserProfile(userKey2);
                String sender = profile2 == null ? "Anonymous" : profile2.getUsername();
                outputResultBuilder.append(seperator + QUOTE).append(sender).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(medalDao.getAchievement().getUuid()).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(medalDao.getAchievement().getName()).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(medalDao.getAchievement().getDescription()).append(QUOTE);
                outputResultBuilder.append("\n");
            }
            outputStream.write(outputResultBuilder.toString().getBytes());
            this.generateBodyMedal(seperator, outputStream, offset + limit, limit, millisStart, millisEnd);
        }
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

