/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.servlet;

import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.moewe.atlassian.sdk.auiforms.FormService;
import io.moewe.atlassian.sdk.auiforms.exceptions.FormException;
import io.moewe.atlassian.sdk.internal.license.MoeweLicenseService;
import io.moewe.confluence.addons.awards.forms.GeneralConfiguration;
import io.moewe.confluence.addons.awards.services.BadgeManager;
import io.moewe.confluence.addons.awards.services.KarmaEventManager;
import io.moewe.confluence.addons.awards.services.KarmaHistoryManager;
import io.moewe.confluence.addons.awards.services.KarmaPropertyManager;
import io.moewe.confluence.addons.awards.services.KarmaScoreManager;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import io.moewe.confluence.addons.awards.services.MedalManager;
import io.moewe.confluence.addons.awards.services.UserAwardsService;
import io.moewe.confluence.addons.awards.util.AwardsHelper;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AwardsServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwardsHelper.class);
    private static final long serialVersionUID = -2488542834682053703L;
    protected TemplateRenderer templateRenderer;
    protected PageBuilderService pageBuilderService;
    protected I18nResolver i18nResolver;
    protected KarmaEventManager karmaEventManager;
    protected UserManager userManager;
    protected BadgeManager badgeManager;
    protected MedalManager medalManager;
    protected KarmaUserManager karmaUserManager;
    protected KarmaPropertyManager karmaPropertyManager;
    protected KarmaHistoryManager karmaHistoryManager;
    protected KarmaScoreManager karmaScoreManager;
    protected PluginAccessor pluginAccessor;
    protected UserAwardsService userAwardsService;
    protected MoeweLicenseService licenseService;
    private final FormService formService;

    public AwardsServlet(@ComponentImport TemplateRenderer templateRenderer, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport I18nResolver i18nResolver, KarmaEventManager karmaEventManager, @ComponentImport UserManager userManager, BadgeManager badgeManager, MedalManager medalManager, KarmaUserManager karmaUserManager, KarmaPropertyManager karmaPropertyManager, KarmaHistoryManager karmaHistoryManager, KarmaScoreManager karmaScoreManager, @ComponentImport PluginAccessor pluginAccessor, UserAwardsService userAwardsService, MoeweLicenseService licenseService, FormService formService) {
        this.templateRenderer = templateRenderer;
        this.pageBuilderService = pageBuilderService;
        this.i18nResolver = i18nResolver;
        this.karmaEventManager = karmaEventManager;
        this.userManager = userManager;
        this.badgeManager = badgeManager;
        this.medalManager = medalManager;
        this.karmaUserManager = karmaUserManager;
        this.karmaPropertyManager = karmaPropertyManager;
        this.karmaHistoryManager = karmaHistoryManager;
        this.karmaScoreManager = karmaScoreManager;
        this.pluginAccessor = pluginAccessor;
        this.userAwardsService = userAwardsService;
        this.licenseService = licenseService;
        this.formService = formService;
    }

    protected boolean validate(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        return true;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.routeRequest(req, resp);
    }

    private void routeRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block4: {
            try {
                if (this.validate(req, resp)) {
                    if (this.userManager.getRemoteUser() == null || this.userManager.getRemoteUser().getUsername().isBlank()) {
                        resp.sendRedirect(req.getContextPath() + "/login.action?os_destination=" + HtmlUtil.urlEncode((String)(String.valueOf(req.getRequestURL()) + "?" + req.getQueryString())));
                    }
                    String requestURI = req.getRequestURI();
                    String[] uriSplit = requestURI.split("/");
                    String methodToCall = uriSplit[uriSplit.length - 1];
                    Class[] params = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
                    Object[] paramsObj = new Object[]{req, resp};
                    Method thisMethod = ((Object)((Object)this)).getClass().getDeclaredMethod(methodToCall, params);
                    thisMethod.invoke((Object)this, paramsObj);
                }
            }
            catch (Throwable throwable) {
                LOGGER.error("Error during karma request " + req.getRequestURI(), throwable);
                if (resp.isCommitted()) break block4;
                resp.sendError(404, throwable.getMessage());
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.routeRequest(req, resp);
    }

    public void renderJSON(HttpServletResponse resp, Map<String, Object> content) throws IOException {
        resp.setContentType("application/json");
        Iterator<Map.Entry<String, Object>> it = content.entrySet().iterator();
        ObjectMapper mapper = new ObjectMapper();
        resp.getWriter().write(mapper.writeValueAsString(content));
        resp.getWriter().close();
    }

    public void renderVelocity(HttpServletRequest request, HttpServletResponse response, String velocityFilePath, Map<String, Object> context) throws IOException {
        response.setContentType("text/html");
        context.put("i18n", this.i18nResolver);
        context.put("req", request);
        context.put("request", request);
        this.templateRenderer.render(velocityFilePath, context, (Writer)response.getWriter());
        response.getWriter().close();
    }

    protected Map<String, FileItem> getFileItemMapFromMultipartRequest(HttpServletRequest req) {
        HashMap<String, FileItem> fileItemMap = new HashMap<String, FileItem>();
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            try {
                List fileItemList = upload.parseRequest(req);
                for (FileItem item : fileItemList) {
                    fileItemMap.put(item.getFieldName(), item);
                }
            }
            catch (FileUploadException e) {
                LOGGER.error("Error during fileupload!", (Throwable)e);
            }
        }
        return fileItemMap;
    }

    protected GeneralConfiguration getGeneralConfiguration() {
        try {
            return this.formService.getForm(GeneralConfiguration.class);
        }
        catch (FormException e) {
            LOGGER.error("Error while retrieving general configuration form", (Throwable)e);
            return null;
        }
    }
}

