/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.moewe.confluence.addons.awards.AwardsEvent;
import io.moewe.confluence.addons.awards.ao.ProcessorEntity;
import io.moewe.confluence.addons.awards.rest.pojo.Processor;
import io.moewe.confluence.addons.awards.rest.pojo.ProcessorMetaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ProcessorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorService.class);
    private final ActiveObjects activeObjects;
    private final UserManager userManager;

    @Inject
    public ProcessorService(@ComponentImport ActiveObjects activeObjects, @ComponentImport UserManager userManager) {
        this.activeObjects = activeObjects;
        this.userManager = userManager;
    }

    public Processor addProcessor(Processor processor) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.userManager.isAdmin(confluenceUser.getKey())) {
            LOGGER.warn("User {} tried to create a category without the needed permission.", (Object)confluenceUser.getName());
            return null;
        }
        Processor sanitizedProcessor = ProcessorService.sanitize(processor);
        if (sanitizedProcessor.getName() == null || sanitizedProcessor.getName().trim().length() == 0) {
            LOGGER.warn("Name may not be empty.");
            return null;
        }
        return ProcessorService.convert((ProcessorEntity)this.activeObjects.executeInTransaction(() -> {
            ProcessorEntity processorEntity = (ProcessorEntity)this.activeObjects.create(ProcessorEntity.class, new DBParam[]{new DBParam("UUID", (Object)UUID.randomUUID().toString()), new DBParam("NAME", (Object)sanitizedProcessor.getName()), new DBParam("DESCRIPTION", (Object)sanitizedProcessor.getDescription()), new DBParam("ENABLED", (Object)sanitizedProcessor.isEnabled()), new DBParam("METADATA", (Object)this.getMetaDataJson(sanitizedProcessor.getMetaData()))});
            LOGGER.debug("ProcessorEntity created: {}", (Object)processorEntity.getUuid());
            processorEntity.save();
            return processorEntity;
        }));
    }

    public Processor updateProcessor(Processor processor) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.userManager.isAdmin(confluenceUser.getKey())) {
            LOGGER.warn("User {} tried to create a category without the needed permission.", (Object)confluenceUser.getName());
            return null;
        }
        Processor sanitizedProcessor = ProcessorService.sanitize(processor);
        if (sanitizedProcessor.getName() == null || sanitizedProcessor.getName().trim().length() == 0) {
            LOGGER.warn("Name may not be empty.");
            return null;
        }
        return ProcessorService.convert((ProcessorEntity)this.activeObjects.executeInTransaction(() -> {
            ProcessorEntity processorEntity = this.getProcessorEntity(sanitizedProcessor.getUuid());
            if (processorEntity == null) {
                LOGGER.warn("There was no processor for uuid {}", (Object)sanitizedProcessor.getUuid());
                return null;
            }
            processorEntity.setName(sanitizedProcessor.getName());
            processorEntity.setDescription(sanitizedProcessor.getDescription());
            processorEntity.setEnabled(sanitizedProcessor.isEnabled());
            processorEntity.setMetaData(this.getMetaDataJson(sanitizedProcessor.getMetaData()));
            processorEntity.save();
            return processorEntity;
        }));
    }

    public void updateProcessors(boolean status) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.userManager.isAdmin(confluenceUser.getKey())) {
            LOGGER.warn("User {} tried to create a category without the needed permission.", (Object)confluenceUser.getName());
            return;
        }
        this.activeObjects.executeInTransaction(() -> {
            ProcessorEntity[] processorEntities = (ProcessorEntity[])this.activeObjects.find(ProcessorEntity.class, Query.select().where("ENABLED != ?", new Object[]{status}));
            Arrays.stream(processorEntities).forEach(processorEntity -> {
                processorEntity.setEnabled(status);
                processorEntity.save();
            });
            return null;
        });
    }

    public void deleteProcessor(String uuid) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.userManager.isAdmin(confluenceUser.getKey())) {
            LOGGER.warn("User {} tried to delete a processor without the needed permission.", (Object)confluenceUser.getName());
            return;
        }
        if (uuid == null) {
            LOGGER.warn("Processor uuid is null");
            return;
        }
        String sanitizedUuid = UUID.fromString(uuid).toString();
        this.activeObjects.executeInTransaction(() -> {
            ProcessorEntity processorEntity = this.getProcessorEntity(sanitizedUuid);
            if (processorEntity != null) {
                this.activeObjects.delete(new RawEntity[]{processorEntity});
            }
            return null;
        });
        LOGGER.debug("Processor deleted: {}", (Object)uuid);
    }

    public Processor getProcessors(String uuid) {
        Query query = Query.select().where("UUID = ? ", new Object[]{uuid}).order("NAME");
        ProcessorEntity[] processorEntities = (ProcessorEntity[])this.activeObjects.find(ProcessorEntity.class, query);
        return processorEntities.length == 0 ? null : ProcessorService.convert(processorEntities[0]);
    }

    public List<Processor> getActiveProcessor() {
        return this.getProcessors(false);
    }

    public List<Processor> getProcessors(boolean includeDisabled) {
        return (List)this.activeObjects.executeInTransaction(() -> {
            ProcessorEntity[] processorEntities;
            Query query = Query.select().order("NAME");
            if (!includeDisabled) {
                query.where("ENABLED = ?", new Object[]{Boolean.TRUE});
            }
            return (processorEntities = (ProcessorEntity[])this.activeObjects.find(ProcessorEntity.class, query)).length == 0 ? new ArrayList() : Arrays.stream(processorEntities).map(ProcessorService::convert).collect(Collectors.toList());
        });
    }

    public List<Processor> getProcessors(AwardsEvent event) {
        return (List)this.activeObjects.executeInTransaction(() -> {
            Query query = Query.select().where("METADATA LIKE ? AND ENABLED = ?", new Object[]{"%\"" + event.name() + "\"%", Boolean.TRUE});
            ProcessorEntity[] processorEntities = (ProcessorEntity[])this.activeObjects.find(ProcessorEntity.class, query);
            return processorEntities.length == 0 ? new ArrayList() : Arrays.stream(processorEntities).map(ProcessorService::convert).collect(Collectors.toList());
        });
    }

    private String getMetaDataJson(ProcessorMetaData processorMetaData) {
        if (processorMetaData != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writeValueAsString(processorMetaData);
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Error on converting achievement meta data to json.", (Throwable)e);
            }
        }
        return "";
    }

    public ProcessorEntity getProcessorEntity(String uuid) {
        Query query = Query.select().where("UUID = ?", new Object[]{uuid});
        ProcessorEntity[] prozessorEntities = (ProcessorEntity[])this.activeObjects.find(ProcessorEntity.class, query);
        return prozessorEntities.length == 0 ? null : prozessorEntities[0];
    }

    public static Processor convert(ProcessorEntity processorEntity) {
        if (processorEntity == null) {
            return null;
        }
        Processor processor = new Processor();
        processor.setUuid(processorEntity.getUuid());
        processor.setEnabled(processorEntity.isEnabled());
        processor.setName(processorEntity.getName());
        processor.setDescription(processorEntity.getDescription());
        if (processorEntity.getMetaData() != null && !processorEntity.getMetaData().isEmpty()) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                processor.setMetaData(mapper.readValue(processorEntity.getMetaData(), ProcessorMetaData.class));
            }
            catch (IOException e) {
                LOGGER.error("Error on converting json to achievement meta data", (Throwable)e);
            }
        }
        return processor;
    }

    private static Processor sanitize(Processor processor) {
        Processor sanitized = new Processor();
        sanitized.setUuid(processor.getUuid());
        sanitized.setEnabled(processor.isEnabled());
        sanitized.setName(processor.getName().trim());
        sanitized.setDescription(StringUtils.trimToEmpty((String)processor.getDescription()));
        sanitized.setMetaData(processor.getMetaData());
        return sanitized;
    }
}

