/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import io.moewe.atlassian.sdk.internal.license.MoeweLicenseService;
import io.moewe.confluence.addons.awards.AwardsEvent;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.ao.KarmaUser;
import io.moewe.confluence.addons.awards.rest.pojo.Achievement;
import io.moewe.confluence.addons.awards.rest.pojo.Processor;
import io.moewe.confluence.addons.awards.rest.pojo.input.Input;
import io.moewe.confluence.addons.awards.rest.pojo.output.AchievementOutput;
import io.moewe.confluence.addons.awards.rest.pojo.output.Output;
import io.moewe.confluence.addons.awards.rest.pojo.output.PointOutput;
import io.moewe.confluence.addons.awards.rest.pojo.parameter.AchievementProcessorParameter;
import io.moewe.confluence.addons.awards.rest.pojo.parameter.ProcessorParameter;
import io.moewe.confluence.addons.awards.services.AchievementService;
import io.moewe.confluence.addons.awards.services.BadgeManager;
import io.moewe.confluence.addons.awards.services.KarmaEventManager;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import io.moewe.confluence.addons.awards.services.ProcessorService;
import io.moewe.confluence.addons.awards.util.AwardsApplicationManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ProcessorRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorRunner.class);
    private final I18nResolver i18nResolver;
    private final ActiveObjects activeObjects;
    private final ProcessorService processorService;
    private final KarmaUserManager karmaUserManager;
    private final KarmaEventManager karmaEventManager;
    private final BadgeManager badgeManager;
    private final AchievementService achievementService;
    private final MoeweLicenseService licenseService;
    private final AwardsApplicationManager awardsApplicationManager;

    @Inject
    public ProcessorRunner(@ComponentImport I18nResolver i18nResolver, @ComponentImport ActiveObjects activeObjects, ProcessorService processorService, KarmaUserManager karmaUserManager, KarmaEventManager karmaEventManager, BadgeManager badgeManager, AchievementService achievementService, MoeweLicenseService licenseService, AwardsApplicationManager awardsApplicationManager) {
        this.i18nResolver = i18nResolver;
        this.activeObjects = activeObjects;
        this.processorService = processorService;
        this.karmaUserManager = karmaUserManager;
        this.karmaEventManager = karmaEventManager;
        this.badgeManager = badgeManager;
        this.achievementService = achievementService;
        this.licenseService = licenseService;
        this.awardsApplicationManager = awardsApplicationManager;
    }

    public void run(ProcessorParameter processorParameter, ConfluenceUser confluenceUser) {
        if (confluenceUser == null) {
            return;
        }
        this.run(processorParameter, this.karmaUserManager.getKarmaUser(confluenceUser));
    }

    public void run(ProcessorParameter processorParameter, KarmaUserProfile karmaUserProfile) {
        if (processorParameter.getAwardsEvent() == null) {
            return;
        }
        if (karmaUserProfile == null || !this.karmaUserManager.isKarmaParticipant(karmaUserProfile) || !this.licenseService.isValid()) {
            return;
        }
        processorParameter.setKarmaUserProfile(karmaUserProfile);
        processorParameter.setKarmaUserTimezone(this.awardsApplicationManager.getUserTimeZone(new UserKey(karmaUserProfile.getUserKey())));
        List<Processor> processors = this.processorService.getProcessors(processorParameter.getAwardsEvent());
        LOGGER.debug("Run processors of awards event {}", (Object)processorParameter.getAwardsEvent().name());
        processors.forEach(processor -> {
            List<Input> inputs = processor.getMetaData().getInputs();
            if (!inputs.isEmpty() && inputs.stream().allMatch(input -> input.isValid(processorParameter))) {
                LOGGER.debug("Run processor with uuid {}", (Object)processor.getUuid());
                List<Output> outputs = processor.getMetaData().getOutputs();
                outputs.forEach(output -> {
                    if (output instanceof AchievementOutput) {
                        Achievement achievement = this.achievementService.getAchievement(((AchievementOutput)output).getAchievementUuid(), false);
                        if (achievement == null) {
                            return;
                        }
                        LOGGER.debug("Run achievement output with achievement uuid " + achievement.getUuid() + " of processor with uuid " + processor.getUuid());
                        if (processorParameter instanceof AchievementProcessorParameter) {
                            AchievementProcessorParameter achievementProcessorParameter = (AchievementProcessorParameter)processorParameter;
                            if (!achievementProcessorParameter.isProcessed(achievement)) {
                                this.runAchievementOutput(processorParameter, karmaUserProfile, achievement, achievementProcessorParameter.getProcessedAchievementUuids());
                            }
                        } else {
                            this.runAchievementOutput(processorParameter, karmaUserProfile, achievement, new HashSet<String>());
                        }
                    } else if (output instanceof PointOutput) {
                        LOGGER.debug("Run point output of processor with uuid " + processor.getUuid());
                        this.karmaEventManager.addPointsOutput(karmaUserProfile, (PointOutput)output, processorParameter);
                    }
                });
            }
        });
    }

    private void runAchievementOutput(ProcessorParameter processorParameter, KarmaUserProfile karmaUserProfile, Achievement achievement, Set<String> processedAchievementUuids) {
        if (this.badgeManager.awardBadge(karmaUserProfile, achievement, processorParameter)) {
            this.run((ProcessorParameter)new AchievementProcessorParameter(AwardsEvent.ACHIEVEMENT_ADDED, achievement, processedAchievementUuids, this.i18nResolver.getText("io.moewe.confluence.addons.awards.management.achievement." + achievement.getType().name().toLowerCase() + ".entityName"), achievement.getName()), karmaUserProfile);
        }
    }

    public void runDecrease(String ... usernames) {
        this.activeObjects.executeInTransaction(() -> {
            KarmaUser[] karmaUsersFromDB;
            Query query = Query.select();
            if (usernames != null && usernames.length > 0) {
                query = query.where("USERNAME IN ?", new Object[]{Boolean.TRUE, usernames});
            }
            for (KarmaUser karmaUserDao : karmaUsersFromDB = (KarmaUser[])this.activeObjects.find(KarmaUser.class, query)) {
                KarmaUserProfile karmaDaoUserToKarmaUserProfile = KarmaUserProfile.createKarmaUserProfile(karmaUserDao);
                if (karmaDaoUserToKarmaUserProfile == null) continue;
                this.run(new ProcessorParameter(AwardsEvent.DECREASE), karmaDaoUserToKarmaUserProfile);
            }
            return null;
        });
    }
}

