/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import io.moewe.confluence.addons.awards.AchievementType;
import io.moewe.confluence.addons.awards.ao.AchievementEntity;
import io.moewe.confluence.addons.awards.ao.BadgeEntry;
import io.moewe.confluence.addons.awards.ao.MedalDao;
import io.moewe.confluence.addons.awards.rest.pojo.Achievement;
import io.moewe.confluence.addons.awards.rest.pojo.AchievementMetaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AchievementService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AchievementService.class);
    private final ActiveObjects activeObjects;
    private final UserManager userManager;

    @Inject
    public AchievementService(@ComponentImport ActiveObjects activeObjects, @ComponentImport UserManager userManager) {
        this.activeObjects = activeObjects;
        this.userManager = userManager;
    }

    public Achievement addAchievement(Achievement achievement) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.userManager.isAdmin(confluenceUser.getKey())) {
            LOGGER.warn("User {} tried to create a category without the needed permission.", (Object)confluenceUser.getName());
            return null;
        }
        Achievement sanitizedAchievement = AchievementService.sanitize(achievement);
        if (sanitizedAchievement.getName() == null || sanitizedAchievement.getName().trim().length() == 0) {
            LOGGER.warn("Name may not be empty.");
            return null;
        }
        return AchievementService.convert((AchievementEntity)this.activeObjects.executeInTransaction(() -> {
            AchievementEntity achievementEntity = (AchievementEntity)this.activeObjects.create(AchievementEntity.class, new DBParam[]{new DBParam("UUID", (Object)UUID.randomUUID().toString()), new DBParam("NAME", (Object)sanitizedAchievement.getName()), new DBParam("TYPE", (Object)sanitizedAchievement.getType().toString()), new DBParam("DESCRIPTION", (Object)sanitizedAchievement.getDescription()), new DBParam("ENABLED", (Object)sanitizedAchievement.isEnabled()), new DBParam("METADATA", (Object)this.getMetaDataJson(sanitizedAchievement.getMetaData()))});
            LOGGER.debug("AchievementEntity created: {}", (Object)achievementEntity.getUuid());
            achievementEntity.save();
            return achievementEntity;
        }));
    }

    public Achievement updateAchievement(Achievement achievement) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.userManager.isAdmin(confluenceUser.getKey())) {
            LOGGER.warn("User {} tried to create a category without the needed permission.", (Object)confluenceUser.getName());
            return null;
        }
        Achievement sanitizedAchievement = AchievementService.sanitize(achievement);
        if (achievement.getName() == null || achievement.getName().trim().length() == 0) {
            LOGGER.warn("Name may not be empty.");
            return null;
        }
        return AchievementService.convert((AchievementEntity)this.activeObjects.executeInTransaction(() -> {
            AchievementEntity achievementEntity = this.getAchievementEntity(sanitizedAchievement.getUuid());
            if (achievementEntity == null) {
                LOGGER.warn("There was no achievement for uuid {}", (Object)sanitizedAchievement.getUuid());
                return null;
            }
            achievementEntity.setName(sanitizedAchievement.getName());
            achievementEntity.setType(sanitizedAchievement.getType().toString());
            achievementEntity.setDescription(sanitizedAchievement.getDescription());
            achievementEntity.setEnabled(sanitizedAchievement.isEnabled());
            achievementEntity.setMetaData(this.getMetaDataJson(sanitizedAchievement.getMetaData()));
            achievementEntity.save();
            return achievementEntity;
        }));
    }

    public void deleteAchievement(String uuid) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.userManager.isAdmin(confluenceUser.getKey())) {
            LOGGER.warn("User {} tried to delete a achievement without the needed permission.", (Object)confluenceUser.getName());
            return;
        }
        if (uuid == null) {
            LOGGER.warn("Achievement uuid is null");
            return;
        }
        String sanitizedUuid = UUID.fromString(uuid).toString();
        this.activeObjects.executeInTransaction(() -> {
            AchievementEntity achievementEntity = this.getAchievementEntity(sanitizedUuid);
            if (achievementEntity != null) {
                BadgeEntry[] badges;
                MedalDao[] medalDaos = (MedalDao[])this.activeObjects.find(MedalDao.class, Query.select().where("ACHIEVEMENT_ID = ?", new Object[]{achievementEntity.getID()}));
                if (medalDaos.length != 0) {
                    for (MedalDao medalDao : medalDaos) {
                        this.activeObjects.delete(new RawEntity[]{medalDao});
                    }
                }
                if ((badges = (BadgeEntry[])this.activeObjects.find(BadgeEntry.class, Query.select().where("ACHIEVEMENT_ID = ?", new Object[]{achievementEntity.getID()}))).length != 0) {
                    for (BadgeEntry badge : badges) {
                        this.activeObjects.delete(new RawEntity[]{badge});
                    }
                }
                this.activeObjects.delete(new RawEntity[]{achievementEntity});
            }
            return null;
        });
        LOGGER.debug("Achievement deleted: {}", (Object)uuid);
    }

    public Achievement getAchievement(String uuid, boolean includeDisabled) {
        AchievementEntity[] achievementEntities;
        ArrayList<Object> parameters = new ArrayList<Object>();
        Object clause = "UUID = ? ";
        parameters.add(uuid);
        if (!includeDisabled) {
            clause = (String)clause + " AND ENABLED = ? ";
            parameters.add(Boolean.TRUE);
        }
        return (achievementEntities = (AchievementEntity[])this.activeObjects.find(AchievementEntity.class, Query.select().where((String)clause, parameters.toArray()))).length == 0 ? null : AchievementService.convert(achievementEntities[0]);
    }

    public List<Achievement> getActiveAchievements(AchievementType type) {
        return this.getAchievements(false, type, null);
    }

    public List<Achievement> getAchievements(boolean includeDisabled, AchievementType type, String term) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        Object clause = " 1=1 ";
        if (!includeDisabled) {
            clause = (String)clause + " AND ENABLED = ? ";
            parameters.add(Boolean.TRUE);
        }
        if (type != null) {
            if (AchievementType.MEDAL.equals((Object)type)) {
                clause = (String)clause + " AND TYPE = ? ";
                parameters.add((Object)AchievementType.MEDAL);
            } else if (AchievementType.BADGE.equals((Object)type)) {
                clause = (String)clause + " AND TYPE = ? ";
                parameters.add((Object)AchievementType.BADGE);
            }
        }
        if (term != null && !term.trim().isEmpty()) {
            clause = (String)clause + " AND NAME LIKE ? ";
            parameters.add("%" + term.trim() + "%");
        }
        AchievementEntity[] achievementEntities = (AchievementEntity[])this.activeObjects.find(AchievementEntity.class, Query.select().where((String)clause, parameters.toArray()));
        return Arrays.stream(achievementEntities).map(AchievementService::convert).collect(Collectors.toList());
    }

    private String getMetaDataJson(AchievementMetaData achievementMetaData) {
        String metaData = "";
        if (achievementMetaData != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                metaData = mapper.writeValueAsString(achievementMetaData);
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Error on converting achievement meta data to json.", (Throwable)e);
            }
        }
        return metaData;
    }

    public AchievementEntity getAchievementEntity(String uuid) {
        Query query = Query.select().where("UUID = ?", new Object[]{uuid});
        AchievementEntity[] achievementEntities = (AchievementEntity[])this.activeObjects.find(AchievementEntity.class, query);
        return achievementEntities.length == 0 ? null : achievementEntities[0];
    }

    public static Achievement convert(AchievementEntity achievementEntity) {
        if (achievementEntity == null) {
            return null;
        }
        Achievement achievement = new Achievement();
        achievement.setUuid(achievementEntity.getUuid());
        if (achievementEntity.getType() == null) {
            achievement.setType(AchievementType.BADGE);
        } else {
            achievement.setType(AchievementType.valueOf(achievementEntity.getType()));
        }
        achievement.setEnabled(achievementEntity.isEnabled());
        achievement.setName(achievementEntity.getName());
        achievement.setDescription(achievementEntity.getDescription());
        if (achievementEntity.getMetaData() != null && !achievementEntity.getMetaData().isEmpty()) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                achievement.setMetaData(mapper.readValue(achievementEntity.getMetaData(), AchievementMetaData.class));
            }
            catch (InvalidTypeIdException e) {
                if (!achievementEntity.getMetaData().contains(AchievementMetaData.class.getName())) {
                    try {
                        Map result = mapper.readValue(achievementEntity.getMetaData(), HashMap.class);
                        result.put("@class", AchievementMetaData.class.getName());
                        mapper.writeValueAsString(result);
                        achievement.setMetaData(mapper.readValue(mapper.writeValueAsString(result), AchievementMetaData.class));
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        LOGGER.error("Error on converting json to achievement meta data", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Error on converting json to achievement meta data", (Throwable)e);
            }
        }
        return achievement;
    }

    private static Achievement sanitize(Achievement achievement) {
        Achievement sanitized = new Achievement();
        sanitized.setType(achievement.getType());
        sanitized.setUuid(achievement.getUuid());
        sanitized.setEnabled(achievement.isEnabled());
        sanitized.setName(achievement.getName().trim());
        sanitized.setDescription(StringUtils.trimToEmpty((String)achievement.getDescription()));
        sanitized.setMetaData(achievement.getMetaData());
        return sanitized;
    }
}

