/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.rest.pojo.input;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moewe.atlassian.sdk.auiforms.annotation.SchemeConfig;
import io.moewe.confluence.addons.awards.AwardsEvent;
import io.moewe.confluence.addons.awards.rest.pojo.input.Input;
import io.moewe.confluence.addons.awards.rest.pojo.parameter.ProcessorParameter;
import java.util.Arrays;

public abstract class AwardsEventInput
extends Input {
    @SchemeConfig(variant=SchemeConfig.Variant.CHECKBOX, order=0)
    private AwardsEvent[] events;
    @JsonIgnore
    protected AwardsEvent[] supportedEvents;

    public AwardsEventInput(AwardsEvent[] supportedEvents) {
        this.supportedEvents = supportedEvents;
    }

    @Override
    public boolean isValid(ProcessorParameter processorParameter) {
        if (this.events != null && processorParameter.getAwardsEvent() != null) {
            return Arrays.stream(this.events).anyMatch(eventItem -> eventItem.equals((Object)processorParameter.getAwardsEvent()));
        }
        return false;
    }

    public AwardsEvent[] getSupportedEvents() {
        return this.supportedEvents;
    }

    public AwardsEvent[] getEvents() {
        return this.events;
    }

    public void setEvents(AwardsEvent[] events) {
        this.events = events;
    }
}

