/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.rest;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import io.moewe.atlassian.sdk.auiforms.Form;
import io.moewe.atlassian.sdk.auiforms.annotation.SchemeConfig;
import io.moewe.atlassian.sdk.auiforms.rest.entities.EntityScheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.FieldOptionScheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.FieldScheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.RepeatableScheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.Scheme;
import io.moewe.atlassian.sdk.auiforms.rest.entities.controller.FormController;
import io.moewe.confluence.addons.awards.AwardsEvent;
import io.moewe.confluence.addons.awards.TimeFrame;
import io.moewe.confluence.addons.awards.rest.pojo.Processor;
import io.moewe.confluence.addons.awards.rest.pojo.ProcessorMetaData;
import io.moewe.confluence.addons.awards.rest.pojo.input.AwardsEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.input.Input;
import io.moewe.confluence.addons.awards.rest.pojo.input.events.ScoreLeaderEventInput;
import io.moewe.confluence.addons.awards.rest.pojo.output.Output;
import io.moewe.confluence.addons.awards.services.ProcessorService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/processor")
@Produces(value={"application/json"})
public class ProcessorResource
extends FormController {
    public static final String NAME_META_DATA_INPUTS_EVENTS = "metaData[inputs][][events][]";
    public static final String NAME_META_DATA_INPUTS_TIMEFRAMES = "metaData[inputs][][timeFrames][]";
    public static final String NAME_META_DATA = "metaData";
    public static final String NAME_META_DATA_INPUTS = "metaData[inputs]";
    public static final String NAME_META_DATA_OUTPUTS = "metaData[outputs]";
    private final ProcessorService processorService;

    public ProcessorResource(ProcessorService processorService, @ComponentImport I18nResolver i18nResolver, @ComponentImport UserManager userManager) {
        super(i18nResolver, userManager, Processor.class);
        this.processorService = processorService;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addProcessor(Processor processor) {
        Processor newProcessor = this.processorService.addProcessor(processor);
        return this.buildProcessorResponse(newProcessor);
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response updateProcessor(Processor processor) {
        Processor updatedProcessor = this.processorService.updateProcessor(processor);
        return this.buildProcessorResponse(updatedProcessor);
    }

    @DELETE
    @Path(value="/{uuid}")
    public Response deleteProcessor(@PathParam(value="uuid") String uuid) {
        this.processorService.deleteProcessor(uuid);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/status")
    public Response updateProcessorsStatus(@QueryParam(value="status") boolean status) {
        this.processorService.updateProcessors(status);
        return Response.ok().build();
    }

    @GET
    public Response getProcessor(@QueryParam(value="includeDisabled") Boolean includeDisabled) {
        List<Processor> processors = this.processorService.getProcessors(includeDisabled != null && includeDisabled != false);
        if (processors != null) {
            try {
                return Response.ok((Object)MAPPER.writeValueAsString(processors)).build();
            }
            catch (Exception e) {
                return Response.serverError().build();
            }
        }
        return Response.serverError().build();
    }

    private Response buildProcessorResponse(Processor processor) {
        if (processor.getUuid() == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(null).build();
        }
        try {
            String responseBody = MAPPER.writeValueAsString(processor);
            return Response.ok((Object)responseBody).build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }

    @Override
    public Class<? extends Form> getFormClass(String id) {
        return Processor.class;
    }

    @Override
    public Form getForm(String id) {
        if (id == null || id.trim().isEmpty()) {
            return new Processor();
        }
        return this.processorService.getProcessors(id);
    }

    @Override
    public Form saveForm(Form form) {
        if (form instanceof Processor) {
            Processor processor = (Processor)form;
            if (processor.getUuid() == null || "".equals(processor.getUuid().trim())) {
                return this.processorService.addProcessor((Processor)form);
            }
            return this.processorService.updateProcessor((Processor)form);
        }
        return null;
    }

    @Override
    public List<Scheme> getSchemeOfForm(Form form) {
        Processor processor;
        List<Scheme> schemes = super.getSchemeOfForm(form);
        if (form instanceof Processor && (processor = (Processor)form).getMetaData() != null) {
            ProcessorMetaData metaData = processor.getMetaData();
            List<Input> inputs = metaData.getInputs();
            List<Output> outputs = metaData.getOutputs();
            schemes.stream().forEach(scheme -> {
                if (NAME_META_DATA.equals(scheme.getName()) && Scheme.Type.ENTITY.equals((Object)scheme.getType())) {
                    ((EntityScheme)scheme).getSchemes().stream().forEach(metaDataScheme -> {
                        if (Scheme.Type.REPEATABLE.equals((Object)metaDataScheme.getType())) {
                            if (NAME_META_DATA_INPUTS.equals(metaDataScheme.getName())) {
                                AtomicInteger index = new AtomicInteger();
                                ((RepeatableScheme)metaDataScheme).getSchemes().forEach(metaDataInputScheme -> this.modifyScheme((Scheme)metaDataInputScheme, inputs.get(index.getAndIncrement())));
                            } else if (NAME_META_DATA_OUTPUTS.equals(metaDataScheme.getName())) {
                                AtomicInteger index = new AtomicInteger();
                                ((RepeatableScheme)metaDataScheme).getSchemes().forEach(metaDataOutputScheme -> this.modifyScheme((Scheme)metaDataOutputScheme, outputs.get(index.getAndIncrement())));
                            }
                        }
                    });
                }
            });
        }
        return schemes;
    }

    @Override
    public Scheme getScheme(String i18nPrefix, String namePrefix, Class<?> schemeClass, Object entity) {
        Scheme scheme = super.getScheme(i18nPrefix, namePrefix, schemeClass, entity);
        this.modifyScheme(scheme, entity);
        return scheme;
    }

    private void modifyScheme(Scheme scheme, Object entity) {
        if (scheme != null && entity != null) {
            if (entity instanceof Input) {
                this.setI18nKeys(entity, scheme, "io.moewe.confluence.addons.awards.rest.pojo.Processor.fields.metaData[inputs].option.");
                this.setInputScheme(entity, scheme);
            } else if (entity instanceof Output) {
                this.setI18nKeys(entity, scheme, "io.moewe.confluence.addons.awards.rest.pojo.Processor.fields.metaData[outputs].option.");
            }
        }
    }

    private void setInputScheme(Object entity, Scheme scheme) {
        Optional<Scheme> schemeOptional;
        if (scheme.getType().equals((Object)Scheme.Type.ENTITY) && entity instanceof AwardsEventInput) {
            ((EntityScheme)scheme).getSchemes().forEach(entityScheme -> {
                if (NAME_META_DATA_INPUTS_EVENTS.equals(entityScheme.getName())) {
                    AwardsEvent[] awardsEvents = ((AwardsEventInput)entity).getSupportedEvents();
                    ArrayList<FieldOptionScheme> options = new ArrayList<FieldOptionScheme>();
                    for (AwardsEvent awardsEvent : awardsEvents) {
                        FieldOptionScheme value = new FieldOptionScheme(this.i18nResolver.getText("io.moewe.confluence.addons.awards.event." + awardsEvent.name() + ".label"), awardsEvent.name());
                        options.add(value);
                    }
                    entityScheme.addFieldParameters("options", options);
                }
            });
        } else if (entity instanceof ScoreLeaderEventInput && (schemeOptional = ((EntityScheme)scheme).getSchemes().stream().filter(inputScheme -> NAME_META_DATA_INPUTS_TIMEFRAMES.equals(inputScheme.getName())).findFirst()).isPresent()) {
            TimeFrame[] timeFrames = TimeFrame.values();
            ArrayList<FieldOptionScheme> options = new ArrayList<FieldOptionScheme>();
            for (TimeFrame timeFrame : timeFrames) {
                FieldOptionScheme value = new FieldOptionScheme(this.i18nResolver.getText("io.moewe.confluence.addons.awards.timeframe." + String.valueOf((Object)timeFrame) + ".label"), timeFrame.name());
                options.add(value);
            }
            FieldScheme eventConditionScheme = (FieldScheme)schemeOptional.get();
            eventConditionScheme.addFieldParameters("options", options);
            eventConditionScheme.setVariant(SchemeConfig.Variant.CHECKBOX.name().toLowerCase());
        }
    }

    private void setI18nKeys(Object entity, Scheme scheme, String i18nKeyPrefix) {
        i18nKeyPrefix = (String)i18nKeyPrefix + entity.getClass().getSimpleName();
        scheme.setLabel(this.i18nResolver.getText((String)i18nKeyPrefix + ".label"));
        scheme.setDescription(this.i18nResolver.getText((String)i18nKeyPrefix + ".description"));
    }
}

