/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.rest;

import io.moewe.confluence.addons.awards.services.BadgeManager;
import io.moewe.confluence.addons.awards.services.KarmaEventManager;
import io.moewe.confluence.addons.awards.services.MedalManager;
import java.text.ParseException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/karma")
@Produces(value={"application/json"})
public class KarmaResource {
    private final KarmaEventManager karmaEventManager;
    private final MedalManager medalManager;
    private final BadgeManager badgeManager;

    public KarmaResource(KarmaEventManager karmaEventManager, MedalManager medalManager, BadgeManager badgeManager) {
        this.karmaEventManager = karmaEventManager;
        this.medalManager = medalManager;
        this.badgeManager = badgeManager;
    }

    @GET
    @Path(value="/reset")
    public Response resetKarma(@QueryParam(value="start") String start, @QueryParam(value="end") String end, @QueryParam(value="type") String type) throws ParseException {
        switch (type) {
            case "points": {
                this.karmaEventManager.deleteKarmaEntries(start, end);
                break;
            }
            case "badge": {
                this.badgeManager.deleteBadgeEntries(start, end);
                break;
            }
            case "medals": {
                this.medalManager.deleteMedalEntries(start, end);
            }
        }
        return Response.ok().build();
    }
}

