/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.rest;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.services.KarmaHistoryManager;
import io.moewe.confluence.addons.awards.services.KarmaScoreManager;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import io.moewe.confluence.addons.awards.services.ProcessorRunner;
import java.util.ArrayList;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/utils")
@Produces(value={"application/json"})
public class AwardsUtilsRestResource {
    private final Logger LOGGER = LoggerFactory.getLogger(AwardsUtilsRestResource.class);
    private final KarmaHistoryManager historyManager;
    private final KarmaScoreManager scoreManager;
    private final ProcessorRunner processorRunner;
    private final KarmaUserManager karmaUserManager;
    private final UserManager userManager;
    private final UserAccessor userAccessor;

    public AwardsUtilsRestResource(KarmaHistoryManager historyManager, KarmaScoreManager scoreManager, KarmaUserManager karmaUserManager, @ComponentImport UserManager userManager, @ComponentImport UserAccessor userAccessor, ProcessorRunner processorRunner) {
        this.historyManager = historyManager;
        this.scoreManager = scoreManager;
        this.processorRunner = processorRunner;
        this.karmaUserManager = karmaUserManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
    }

    @POST
    @Path(value="/users/calculate")
    public Response calculateHistory(@QueryParam(value="username") @DefaultValue(value="") String username) {
        if (!this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (username.isEmpty()) {
            this.historyManager.storeKarmaToHistory(new String[0]);
            this.processorRunner.runDecrease(new String[0]);
        } else {
            String userKey = this.userAccessor.getUserByName(username).getKey().getStringValue();
            this.historyManager.storeKarmaToHistory(userKey);
            this.processorRunner.runDecrease(userKey);
        }
        this.scoreManager.calculateUserScore();
        return Response.ok().build();
    }

    public Response removeOrphans(@QueryParam(value="doit") @DefaultValue(value="false") boolean doit) {
        if (!this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (!doit) {
            return Response.serverError().build();
        }
        ArrayList removedUsers = new ArrayList();
        this.karmaUserManager.getKarmaUsers(new String[0]).forEach(user -> {
            UserProfile userProfile = this.userManager.getUserProfile(user.getUserKey());
            if (userProfile == null) {
                this.LOGGER.debug("Found orphaned KarmaUser: {}, will remove it.", (Object)user.getUserKey());
                this.karmaUserManager.deleteUser((KarmaUserProfile)user);
                removedUsers.add(user.getUserKey());
            }
        });
        this.historyManager.storeKarmaToHistory(new String[0]);
        this.processorRunner.runDecrease(new String[0]);
        this.scoreManager.calculateUserScore();
        return Response.ok(removedUsers).build();
    }
}

