/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.moewe.atlassian.sdk.auiforms.FormService;
import io.moewe.atlassian.sdk.auiforms.exceptions.FormException;
import io.moewe.confluence.addons.awards.KarmaEvent;
import io.moewe.confluence.addons.awards.KarmaScore;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.TimeFrame;
import io.moewe.confluence.addons.awards.ao.BadgeEntry;
import io.moewe.confluence.addons.awards.ao.KarmaHistoryEntry;
import io.moewe.confluence.addons.awards.forms.GeneralConfiguration;
import io.moewe.confluence.addons.awards.rest.pojo.UserBadgeEntry;
import io.moewe.confluence.addons.awards.rest.pojo.UserEntry;
import io.moewe.confluence.addons.awards.services.BadgeManager;
import io.moewe.confluence.addons.awards.services.KarmaEventManager;
import io.moewe.confluence.addons.awards.services.KarmaHistoryManager;
import io.moewe.confluence.addons.awards.services.KarmaScoreManager;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import io.moewe.confluence.addons.awards.services.UserAwardsService;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/user")
@Produces(value={"application/json"})
public class AwardsUserRestResource {
    private final Logger LOGGER = LoggerFactory.getLogger(AwardsUserRestResource.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final KarmaEventManager eventManager;
    private final KarmaUserManager userManager;
    private final KarmaHistoryManager karmaHistoryManager;
    private final BadgeManager badgeManager;
    private final KarmaScoreManager karmaScoreManager;
    private final UserAwardsService userAwardsService;
    private final FormService formService;

    public AwardsUserRestResource(KarmaEventManager eventManager, KarmaUserManager userManager, KarmaHistoryManager karmaHistoryManager, BadgeManager badgeManager, KarmaScoreManager karmaScoreManager, UserAwardsService userAwardsService, FormService formService) {
        this.eventManager = eventManager;
        this.userManager = userManager;
        this.karmaHistoryManager = karmaHistoryManager;
        this.badgeManager = badgeManager;
        this.karmaScoreManager = karmaScoreManager;
        this.userAwardsService = userAwardsService;
        this.formService = formService;
    }

    @GET
    @Path(value="/{username}/events")
    public Response getLatestEvents(@PathParam(value="username") String username, @DefaultValue(value="20") @QueryParam(value="limit") Integer limit) {
        KarmaUserProfile user = this.userManager.getKarmaUserFromUsername(username);
        List<KarmaEvent> karmaEntries = this.eventManager.getLastKarmaEntries(user, limit);
        try {
            return Response.ok((Object)OBJECT_MAPPER.writeValueAsString(karmaEntries)).build();
        }
        catch (JsonProcessingException e) {
            this.LOGGER.error("Error while processing object to json.", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/{username}/profile")
    public Response getProfile(@PathParam(value="username") String username) {
        if (username == null || username.trim().isEmpty()) {
            username = AuthenticatedUserThreadLocal.getUsername();
        }
        try {
            return Response.ok((Object)OBJECT_MAPPER.writeValueAsString(this.getUserEntry(username, this.getUnit()))).build();
        }
        catch (JsonProcessingException e) {
            this.LOGGER.error("Error while processing object to json.", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/{username}/history/points")
    public Response getHistoryPoints(@PathParam(value="username") String username) {
        ArrayList historyEntries = new ArrayList();
        KarmaUserProfile karmaUser = this.userManager.getKarmaUserFromUsername(username);
        if (karmaUser != null) {
            KarmaHistoryEntry[] karmaHistoryEntries;
            for (KarmaHistoryEntry karmaHistoryEntry : karmaHistoryEntries = this.karmaHistoryManager.loadKarmaHistoryForUser(karmaUser)) {
                ArrayList<Long> dataEntry = new ArrayList<Long>();
                dataEntry.add(karmaHistoryEntry.getHistoryTime());
                dataEntry.add(Long.valueOf(karmaHistoryEntry.getKarma()));
                historyEntries.add(dataEntry);
            }
        }
        try {
            return Response.ok((Object)OBJECT_MAPPER.writeValueAsString(historyEntries)).build();
        }
        catch (JsonProcessingException e) {
            this.LOGGER.error("Error while processing object to json.", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/profiles")
    public Response getProfiles(@QueryParam(value="usernames") String usernames) {
        ArrayList<UserEntry> userEntries = new ArrayList<UserEntry>();
        String unit = this.getUnit();
        if (usernames != null && !usernames.trim().isEmpty()) {
            for (String username : usernames.split(",")) {
                UserEntry userEntry = this.getUserEntry(username, unit);
                if (userEntry == null) continue;
                userEntries.add(userEntry);
            }
        }
        try {
            return Response.ok((Object)OBJECT_MAPPER.writeValueAsString(userEntries)).build();
        }
        catch (JsonProcessingException e) {
            this.LOGGER.error("Error while processing object to json.", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private UserEntry getUserEntry(String username, String unit) {
        KarmaUserProfile karmaUser = this.userManager.getKarmaUserFromUsername(username);
        UserEntry userEntry = null;
        if (karmaUser != null && this.userManager.isKarmaParticipant(karmaUser)) {
            ArrayList<UserBadgeEntry> userBadgeEntries = new ArrayList<UserBadgeEntry>();
            for (BadgeEntry badgeEntry : this.badgeManager.getUserBadges(karmaUser)) {
                if (badgeEntry.getAchievement() == null || !badgeEntry.getAchievement().isEnabled()) continue;
                userBadgeEntries.add(new UserBadgeEntry(badgeEntry));
            }
            KarmaScore score = this.karmaScoreManager.getScore(karmaUser, TimeFrame.OVERALL);
            int totalPoints = score != null ? score.getScore() : 0;
            ConfluenceUser confluenceUser = this.userAwardsService.getUser(karmaUser.getKarmaUserDao());
            userEntry = new UserEntry(totalPoints, unit, confluenceUser.getName(), confluenceUser.getFullName(), userBadgeEntries);
        }
        return userEntry;
    }

    private String getUnit() {
        String unit = "";
        try {
            unit = this.formService.getForm(GeneralConfiguration.class).getUnit();
        }
        catch (FormException e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return unit;
    }

    static {
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

