/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import io.moewe.confluence.addons.awards.ao.KarmaProperty;
import io.moewe.confluence.addons.awards.ao.KarmaUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService
public class MigrateUsernameTask
implements PluginUpgradeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrateUsernameTask.class);
    private final ActiveObjects ao;

    @Inject
    public MigrateUsernameTask(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    public Collection<Message> doUpgrade() {
        this.ao.executeInTransaction(() -> {
            KarmaProperty[] karmaProperties = (KarmaProperty[])this.ao.find(KarmaProperty.class, Query.select().where("KEY = ?", new Object[]{"duplicate.user.migration.done"}));
            boolean userMigrationDone = false;
            if (karmaProperties != null && karmaProperties.length > 0 && "true".equals(karmaProperties[0].getValue())) {
                userMigrationDone = true;
            }
            if (!userMigrationDone) {
                KarmaUser[] allNullNameKarmaUsers;
                LOGGER.warn("Running user migration...");
                LOGGER.warn("Remove NULL users...");
                for (KarmaUser karmaUser : allNullNameKarmaUsers = (KarmaUser[])this.ao.find(KarmaUser.class, Query.select().where("USERNAME IS NULL", new Object[0]))) {
                    this.deleteKarmaUser(karmaUser);
                }
                LOGGER.warn("Running duplicate user migration...");
                HashMap karmaUserSet = new HashMap();
                KarmaUser[] allKarmaUsers = (KarmaUser[])this.ao.find(KarmaUser.class, Query.select().from(KarmaUser.class).where("ACTIVE = ?", new Object[]{Boolean.TRUE}));
                for (KarmaUser karmaUser : allKarmaUsers) {
                    String username = karmaUser.getUsername() != null ? karmaUser.getUsername() : "";
                    String lowercaseUsername = username.toLowerCase();
                    List<KarmaUser> userListPerName = null;
                    if (karmaUserSet.get(lowercaseUsername) != null) {
                        userListPerName = (List)karmaUserSet.get(lowercaseUsername);
                    } else {
                        userListPerName = new ArrayList();
                        karmaUserSet.put(lowercaseUsername, userListPerName);
                    }
                    userListPerName.add(karmaUser);
                }
                for (Map.Entry entry : karmaUserSet.entrySet()) {
                    if (((List)entry.getValue()).size() > 1) {
                        LOGGER.warn("Found duplicate Karma users for user " + (String)entry.getKey());
                        KarmaUser theWinningKarmaUser = null;
                        for (KarmaUser karmaUserFromGroupedUsers : (List)entry.getValue()) {
                            if (theWinningKarmaUser != null && karmaUserFromGroupedUsers.getTotalKarma() < theWinningKarmaUser.getTotalKarma()) continue;
                            theWinningKarmaUser = karmaUserFromGroupedUsers;
                        }
                        LOGGER.warn("The Karma user " + theWinningKarmaUser.getUsername() + " with " + theWinningKarmaUser.getTotalKarma() + " Karma prevails");
                        ((List)entry.getValue()).remove(theWinningKarmaUser);
                        for (KarmaUser aLooser : (List)entry.getValue()) {
                            this.deleteKarmaUser(aLooser);
                        }
                        ((List)entry.getValue()).clear();
                        ((List)entry.getValue()).add(theWinningKarmaUser);
                    }
                    if (((List)entry.getValue()).size() == 1) {
                        KarmaUser karmaUserToLowerCase = (KarmaUser)((List)entry.getValue()).get(0);
                        LOGGER.warn("Lowercasing the user " + karmaUserToLowerCase.getUsername());
                        karmaUserToLowerCase.setUsername(karmaUserToLowerCase.getUsername().toLowerCase());
                        karmaUserToLowerCase.save();
                        continue;
                    }
                    LOGGER.error("Something strange happens. There are still duplicate users left.");
                }
                assert (karmaProperties != null);
                KarmaProperty karmaProperty = karmaProperties.length > 0 ? karmaProperties[0] : (KarmaProperty)this.ao.create(KarmaProperty.class, new DBParam[0]);
                karmaProperty.setKey("duplicate.user.migration.done");
                karmaProperty.setValue("true");
                karmaProperty.save();
                LOGGER.warn("Duplicate user migration done.");
            }
            return null;
        });
        return new ArrayList<Message>();
    }

    private void deleteKarmaUser(KarmaUser karmaUser) {
        karmaUser.setActive(false);
        karmaUser.save();
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getPluginKey() {
        return "de.communardo.confluence.plugins.karma";
    }

    public String getShortDescription() {
        return "Migrates the karma users to lowercase";
    }
}

