/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import io.moewe.confluence.addons.awards.ao.KarmaEntry;
import io.moewe.confluence.addons.awards.ao.KarmaProperty;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService
public class KarmaEntryUpgradeTask
implements PluginUpgradeTask {
    private final ActiveObjects ao;
    private static final Logger LOGGER = LoggerFactory.getLogger(KarmaEntryUpgradeTask.class);

    @Inject
    public KarmaEntryUpgradeTask(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    public Collection<Message> doUpgrade() {
        this.ao.executeInTransaction(() -> {
            KarmaProperty[] karmaProperties = (KarmaProperty[])this.ao.find(KarmaProperty.class, Query.select().where("KEY = ?", new Object[]{"karmaentry.new.column.eventid.migration"}));
            boolean migrationDone = false;
            if (karmaProperties != null && karmaProperties.length > 0 && "true".equals(karmaProperties[0].getValue())) {
                migrationDone = true;
            }
            if (!migrationDone) {
                KarmaEntry[] entries;
                LOGGER.warn("Running Karmaentry migration...");
                String prefix = "communardo.karmaevent.";
                String postfix = ".eventmessage";
                int stepWidth = 10000;
                int offset = 0;
                while ((entries = (KarmaEntry[])this.ao.find(KarmaEntry.class, Query.select().order("ID ASC").limit(stepWidth).offset(offset))).length > 0) {
                    for (KarmaEntry karmaEntry : entries) {
                        String description = karmaEntry.getDescription();
                        if (description != null && description.endsWith(postfix) && description.startsWith(prefix)) {
                            String eventKey = description.substring(0, description.lastIndexOf(postfix));
                            eventKey = eventKey.substring(prefix.length());
                            karmaEntry.setEventKey(eventKey);
                            karmaEntry.save();
                            continue;
                        }
                        LOGGER.error("Migration of EventID field failed because the description value is: " + description);
                    }
                    offset += stepWidth;
                }
                assert (karmaProperties != null);
                KarmaProperty karmaProperty = karmaProperties.length > 0 ? karmaProperties[0] : (KarmaProperty)this.ao.create(KarmaProperty.class, new DBParam[0]);
                karmaProperty.setKey("karmaentry.new.column.eventid.migration");
                karmaProperty.setValue("true");
                karmaProperty.save();
                LOGGER.warn("Karmaentry migration done.");
            }
            return null;
        });
        return Collections.emptySet();
    }

    public int getBuildNumber() {
        return 4;
    }

    public String getPluginKey() {
        return "de.communardo.confluence.plugins.karma";
    }

    public String getShortDescription() {
        return "Migrates the karma event key to the new column eventkey in the table KarmaEntry";
    }
}

