/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.macros;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import io.moewe.atlassian.sdk.auiforms.FormService;
import io.moewe.atlassian.sdk.auiforms.exceptions.FormException;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.forms.GeneralConfiguration;
import io.moewe.confluence.addons.awards.services.KarmaEventManager;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import io.moewe.confluence.addons.awards.util.AwardsApplicationManager;
import io.moewe.confluence.addons.awards.util.AwardsHelper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwardsHistoryMacro
extends BaseMacro {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwardsHelper.class);
    private final PageBuilderService pageBuilderService;
    private final KarmaUserManager karmaUserManager;
    private final KarmaEventManager karmaEventManager;
    private final AwardsApplicationManager applicationManager;
    private final FormService formService;
    private static final String MACRO_TEMPLATE = "/vm/karmahistorymacro.vm";
    private static final int DEFAULT_LIMIT = 15;
    private static final String DEFAULT_USERNAME = "admin";

    public AwardsHistoryMacro(PageBuilderService pageBuilderService, KarmaUserManager karmaUserManager, KarmaEventManager karmaEventManager, AwardsApplicationManager applicationManager, FormService formService) {
        this.pageBuilderService = pageBuilderService;
        this.karmaUserManager = karmaUserManager;
        this.karmaEventManager = karmaEventManager;
        this.applicationManager = applicationManager;
        this.formService = formService;
    }

    public String execute(Map parameters, String body, RenderContext context) {
        Map velocityContext = MacroUtils.defaultVelocityContext();
        int limit = parameters.get("limit") != null ? Integer.parseInt(parameters.get("limit").toString()) : 15;
        String username = parameters.get("username") != null ? parameters.get("username").toString() : DEFAULT_USERNAME;
        KarmaUserProfile karmaUserFromUsername = this.karmaUserManager.getKarmaUserFromUsername(username);
        GeneralConfiguration generalConfiguration = this.getGeneralConfiguration();
        velocityContext.put("selectedKarmaUser", karmaUserFromUsername);
        velocityContext.put("lastKarmaEntries", this.karmaEventManager.getLastKarmaEntries(karmaUserFromUsername, limit));
        velocityContext.put("dateFormatter", this.applicationManager.getDateFormatter());
        velocityContext.put("unit", generalConfiguration.getUnit());
        this.pageBuilderService.assembler().resources().requireContext("karma.macro.history");
        return VelocityUtils.getRenderedTemplate((String)MACRO_TEMPLATE, (Map)velocityContext);
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public boolean hasBody() {
        return false;
    }

    protected GeneralConfiguration getGeneralConfiguration() {
        try {
            return this.formService.getForm(GeneralConfiguration.class);
        }
        catch (FormException e) {
            LOGGER.error("Error while retrieving general configuration form", (Throwable)e);
            return null;
        }
    }
}

