/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.awards.macros;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import io.moewe.confluence.addons.awards.AchievementType;
import io.moewe.confluence.addons.awards.KarmaUserProfile;
import io.moewe.confluence.addons.awards.services.AchievementService;
import io.moewe.confluence.addons.awards.services.BadgeManager;
import io.moewe.confluence.addons.awards.services.KarmaUserManager;
import io.moewe.confluence.addons.awards.services.MedalManager;
import io.moewe.confluence.addons.awards.services.UserAwardsService;
import io.moewe.confluence.addons.awards.util.AwardsApplicationManager;
import io.moewe.confluence.addons.awards.util.AwardsHelper;
import java.util.Map;

public class AwardsAchievementsMacro
extends BaseMacro {
    private static final String MACRO_TEMPLATE = "/vm/karmaachievements.vm";
    private static final String DEFAULT_TYPE = "BADGE";
    private final MedalManager medalManager;
    private final BadgeManager badgeManager;
    private final KarmaUserManager karmaUserManager;
    private final PageBuilderService pageBuilderService;
    private final AwardsApplicationManager karmaApplicationService;
    private final UserManager userManager;
    private final UserAwardsService userAwardsService;
    private final AchievementService achievementService;

    public AwardsAchievementsMacro(MedalManager medalManager, BadgeManager badgeManager, KarmaUserManager karmaUserManager, @ComponentImport PageBuilderService pageBuilderService, AwardsApplicationManager karmaApplicationService, @ComponentImport UserManager userManager, UserAwardsService userAwardsService, AchievementService achievementService) {
        this.medalManager = medalManager;
        this.badgeManager = badgeManager;
        this.karmaUserManager = karmaUserManager;
        this.pageBuilderService = pageBuilderService;
        this.karmaApplicationService = karmaApplicationService;
        this.userManager = userManager;
        this.userAwardsService = userAwardsService;
        this.achievementService = achievementService;
    }

    public String execute(Map parameters, String body, RenderContext context) {
        Map velocityContext = MacroUtils.defaultVelocityContext();
        parameters.putIfAbsent("type", DEFAULT_TYPE);
        AchievementType type = AchievementType.valueOf(String.valueOf(parameters.get("type")));
        String username = parameters.get("username") != null ? parameters.get("username").toString() : AuthenticatedUserThreadLocal.getUsername();
        KarmaUserProfile karmaUserFromUsername = this.karmaUserManager.getKarmaUserFromUsername(username);
        if (type.equals((Object)AchievementType.BADGE)) {
            velocityContext.put("badgeAchievements", this.achievementService.getActiveAchievements(type));
            velocityContext.put("achievements", this.badgeManager.convertBadgeEntriesToUserAchievements(karmaUserFromUsername));
        } else {
            velocityContext.put("medalAchievements", this.achievementService.getActiveAchievements(type));
            velocityContext.put("preselectedMedalUser", username);
            velocityContext.put("achievements", this.medalManager.convertMedalsToUserAchievements(karmaUserFromUsername));
        }
        velocityContext.put("type", type.toString());
        velocityContext.put("userAwardsService", this.userAwardsService);
        velocityContext.put("karmaHelper", new AwardsHelper());
        velocityContext.put("dateFormatter", this.karmaApplicationService.getDateFormatter());
        velocityContext.put("karmaUserManager", this.karmaUserManager);
        velocityContext.put("userManager", this.userManager);
        velocityContext.put("medalStream", false);
        this.pageBuilderService.assembler().resources().requireContext("karma.macro.karmaachievements");
        this.pageBuilderService.assembler().resources().requireContext("");
        return VelocityUtils.getRenderedTemplate((String)MACRO_TEMPLATE, (Map)velocityContext);
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public boolean hasBody() {
        return false;
    }
}

